/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import java.util.Locale;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.GeometricMean;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.apache.commons.math3.stat.descriptive.summary.SumOfSquares;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class DescriptiveStatisticsTest {
    protected DescriptiveStatistics createDescriptiveStatistics() {
        return new DescriptiveStatistics();
    }

    @Test
    public void testSetterInjection() {
        DescriptiveStatistics stats = this.createDescriptiveStatistics();
        stats.addValue(1.0);
        stats.addValue(3.0);
        Assert.assertEquals((double)2.0, (double)stats.getMean(), (double)1.0E-10);
        stats.setMeanImpl((UnivariateStatistic)new deepMean());
        Assert.assertEquals((double)42.0, (double)stats.getMean(), (double)1.0E-10);
    }

    @Test
    public void testCopy() {
        DescriptiveStatistics stats = this.createDescriptiveStatistics();
        stats.addValue(1.0);
        stats.addValue(3.0);
        DescriptiveStatistics copy = new DescriptiveStatistics(stats);
        Assert.assertEquals((double)2.0, (double)copy.getMean(), (double)1.0E-10);
        stats.setMeanImpl((UnivariateStatistic)new deepMean());
        copy = stats.copy();
        Assert.assertEquals((double)42.0, (double)copy.getMean(), (double)1.0E-10);
    }

    @Test
    public void testWindowSize() {
        DescriptiveStatistics stats = this.createDescriptiveStatistics();
        stats.setWindowSize(300);
        for (int i = 0; i < 100; ++i) {
            stats.addValue((double)(i + 1));
        }
        int refSum = 5050;
        Assert.assertEquals((double)((double)refSum / 100.0), (double)stats.getMean(), (double)1.0E-10);
        Assert.assertEquals((long)300L, (long)stats.getWindowSize());
        try {
            stats.setWindowSize(-3);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)300L, (long)stats.getWindowSize());
        stats.setWindowSize(50);
        Assert.assertEquals((long)50L, (long)stats.getWindowSize());
        int refSum2 = refSum - 1275;
        Assert.assertEquals((double)((double)refSum2 / 50.0), (double)stats.getMean(), (double)1.0E-10);
    }

    @Test
    public void testGetValues() {
        DescriptiveStatistics stats = this.createDescriptiveStatistics();
        for (int i = 100; i > 0; --i) {
            stats.addValue((double)i);
        }
        int refSum = 5050;
        Assert.assertEquals((double)((double)refSum / 100.0), (double)stats.getMean(), (double)1.0E-10);
        double[] v = stats.getValues();
        for (int i = 0; i < v.length; ++i) {
            Assert.assertEquals((double)(100.0 - (double)i), (double)v[i], (double)1.0E-10);
        }
        double[] s = stats.getSortedValues();
        for (int i = 0; i < s.length; ++i) {
            Assert.assertEquals((double)((double)i + 1.0), (double)s[i], (double)1.0E-10);
        }
        Assert.assertEquals((double)12.0, (double)stats.getElement(88), (double)1.0E-10);
    }

    @Test
    public void testQuadraticMean() {
        double[] values = new double[]{1.2, 3.4, 5.6, 7.89};
        DescriptiveStatistics stats = new DescriptiveStatistics(values);
        int len = values.length;
        double expected = 0.0;
        for (int i = 0; i < len; ++i) {
            double v = values[i];
            expected += v * v / (double)len;
        }
        expected = Math.sqrt(expected);
        Assert.assertEquals((double)expected, (double)stats.getQuadraticMean(), (double)Math.ulp(expected));
    }

    @Test
    public void testToString() {
        DescriptiveStatistics stats = this.createDescriptiveStatistics();
        stats.addValue(1.0);
        stats.addValue(2.0);
        stats.addValue(3.0);
        Locale d = Locale.getDefault();
        Locale.setDefault(Locale.US);
        Assert.assertEquals((Object)"DescriptiveStatistics:\nn: 3\nmin: 1.0\nmax: 3.0\nmean: 2.0\nstd dev: 1.0\nmedian: 2.0\nskewness: 0.0\nkurtosis: NaN\n", (Object)stats.toString());
        Locale.setDefault(d);
    }

    @Test
    public void testShuffledStatistics() {
        DescriptiveStatistics reference = this.createDescriptiveStatistics();
        DescriptiveStatistics shuffled = this.createDescriptiveStatistics();
        UnivariateStatistic tmp = shuffled.getGeometricMeanImpl();
        shuffled.setGeometricMeanImpl(shuffled.getMeanImpl());
        shuffled.setMeanImpl(shuffled.getKurtosisImpl());
        shuffled.setKurtosisImpl(shuffled.getSkewnessImpl());
        shuffled.setSkewnessImpl(shuffled.getVarianceImpl());
        shuffled.setVarianceImpl(shuffled.getMaxImpl());
        shuffled.setMaxImpl(shuffled.getMinImpl());
        shuffled.setMinImpl(shuffled.getSumImpl());
        shuffled.setSumImpl(shuffled.getSumsqImpl());
        shuffled.setSumsqImpl(tmp);
        for (int i = 100; i > 0; --i) {
            reference.addValue((double)i);
            shuffled.addValue((double)i);
        }
        Assert.assertEquals((double)reference.getMean(), (double)shuffled.getGeometricMean(), (double)1.0E-10);
        Assert.assertEquals((double)reference.getKurtosis(), (double)shuffled.getMean(), (double)1.0E-10);
        Assert.assertEquals((double)reference.getSkewness(), (double)shuffled.getKurtosis(), (double)1.0E-10);
        Assert.assertEquals((double)reference.getVariance(), (double)shuffled.getSkewness(), (double)1.0E-10);
        Assert.assertEquals((double)reference.getMax(), (double)shuffled.getVariance(), (double)1.0E-10);
        Assert.assertEquals((double)reference.getMin(), (double)shuffled.getMax(), (double)1.0E-10);
        Assert.assertEquals((double)reference.getSum(), (double)shuffled.getMin(), (double)1.0E-10);
        Assert.assertEquals((double)reference.getSumsq(), (double)shuffled.getSum(), (double)1.0E-10);
        Assert.assertEquals((double)reference.getGeometricMean(), (double)shuffled.getSumsq(), (double)1.0E-10);
    }

    @Test
    public void testPercentileSetter() {
        DescriptiveStatistics stats = this.createDescriptiveStatistics();
        stats.addValue(1.0);
        stats.addValue(2.0);
        stats.addValue(3.0);
        Assert.assertEquals((double)2.0, (double)stats.getPercentile(50.0), (double)1.0E-10);
        stats.setPercentileImpl((UnivariateStatistic)new goodPercentile());
        Assert.assertEquals((double)2.0, (double)stats.getPercentile(50.0), (double)1.0E-10);
        stats.setPercentileImpl((UnivariateStatistic)new subPercentile());
        Assert.assertEquals((double)10.0, (double)stats.getPercentile(10.0), (double)1.0E-10);
        try {
            stats.setPercentileImpl((UnivariateStatistic)new badPercentile());
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test20090720() {
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics(100);
        for (int i = 0; i < 161; ++i) {
            descriptiveStatistics.addValue(1.2);
        }
        descriptiveStatistics.clear();
        descriptiveStatistics.addValue(1.2);
        Assert.assertEquals((long)1L, (long)descriptiveStatistics.getN());
    }

    @Test
    public void testRemoval() {
        DescriptiveStatistics dstat = this.createDescriptiveStatistics();
        this.checkremoval(dstat, 1, 6.0, 0.0, Double.NaN);
        this.checkremoval(dstat, 3, 5.0, 3.0, 4.5);
        this.checkremoval(dstat, 6, 3.5, 2.5, 3.0);
        this.checkremoval(dstat, 9, 3.5, 2.5, 3.0);
        this.checkremoval(dstat, -1, 3.5, 2.5, 3.0);
    }

    @Test
    public void testSummaryConsistency() {
        DescriptiveStatistics dstats = new DescriptiveStatistics();
        SummaryStatistics sstats = new SummaryStatistics();
        int windowSize = 5;
        dstats.setWindowSize(5);
        double tol = 1.0E-12;
        for (int i = 0; i < 20; ++i) {
            dstats.addValue((double)i);
            sstats.clear();
            double[] values = dstats.getValues();
            for (int j = 0; j < values.length; ++j) {
                sstats.addValue(values[j]);
            }
            TestUtils.assertEquals(dstats.getMean(), sstats.getMean(), 1.0E-12);
            TestUtils.assertEquals(new Mean().evaluate(values), dstats.getMean(), 1.0E-12);
            TestUtils.assertEquals(dstats.getMax(), sstats.getMax(), 1.0E-12);
            TestUtils.assertEquals(new Max().evaluate(values), dstats.getMax(), 1.0E-12);
            TestUtils.assertEquals(dstats.getGeometricMean(), sstats.getGeometricMean(), 1.0E-12);
            TestUtils.assertEquals(new GeometricMean().evaluate(values), dstats.getGeometricMean(), 1.0E-12);
            TestUtils.assertEquals(dstats.getMin(), sstats.getMin(), 1.0E-12);
            TestUtils.assertEquals(new Min().evaluate(values), dstats.getMin(), 1.0E-12);
            TestUtils.assertEquals(dstats.getStandardDeviation(), sstats.getStandardDeviation(), 1.0E-12);
            TestUtils.assertEquals(dstats.getVariance(), sstats.getVariance(), 1.0E-12);
            TestUtils.assertEquals(new Variance().evaluate(values), dstats.getVariance(), 1.0E-12);
            TestUtils.assertEquals(dstats.getSum(), sstats.getSum(), 1.0E-12);
            TestUtils.assertEquals(new Sum().evaluate(values), dstats.getSum(), 1.0E-12);
            TestUtils.assertEquals(dstats.getSumsq(), sstats.getSumsq(), 1.0E-12);
            TestUtils.assertEquals(new SumOfSquares().evaluate(values), dstats.getSumsq(), 1.0E-12);
            TestUtils.assertEquals(dstats.getPopulationVariance(), sstats.getPopulationVariance(), 1.0E-12);
            TestUtils.assertEquals(new Variance(false).evaluate(values), dstats.getPopulationVariance(), 1.0E-12);
        }
    }

    @Test
    public void testMath1129() {
        double o;
        double[] data = new double[]{-0.012086732064244697, -0.24975668704012527, 0.5706168483164684, -0.322111769955327, 0.24166759508327315, Double.NaN, 0.16698443218942854, -0.10427763937565114, -0.15595963093172435, -0.028075857595882995, -0.24137994506058857, 0.47543170476574426, -0.07495595384947631, 0.37445697625436497, -0.09944199541668033};
        DescriptiveStatistics ds = new DescriptiveStatistics(data);
        double t = ds.getPercentile(75.0);
        double iqr = t - (o = ds.getPercentile(25.0));
        Assert.assertTrue((iqr >= 0.0 ? 1 : 0) != 0);
    }

    public void checkremoval(DescriptiveStatistics dstat, int wsize, double mean1, double mean2, double mean3) {
        dstat.setWindowSize(wsize);
        dstat.clear();
        for (int i = 1; i <= 6; ++i) {
            dstat.addValue((double)i);
        }
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)mean1, (double)dstat.getMean()));
        dstat.replaceMostRecentValue(0.0);
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)mean2, (double)dstat.getMean()));
        dstat.removeMostRecentValue();
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)mean3, (double)dstat.getMean()));
    }

    static class badPercentile
    implements UnivariateStatistic {
        private Percentile percentile = new Percentile();

        badPercentile() {
        }

        public double evaluate(double[] values, int begin, int length) {
            return this.percentile.evaluate(values, begin, length);
        }

        public double evaluate(double[] values) {
            return this.percentile.evaluate(values);
        }

        public UnivariateStatistic copy() {
            return new badPercentile();
        }
    }

    static class subPercentile
    extends Percentile {
        private static final long serialVersionUID = 8040701391045914979L;

        subPercentile() {
        }

        public double evaluate(double[] values, int begin, int length) {
            return this.getQuantile();
        }

        public double evaluate(double[] values) {
            return this.getQuantile();
        }

        public Percentile copy() {
            subPercentile result = new subPercentile();
            return result;
        }
    }

    static class goodPercentile
    implements UnivariateStatistic {
        private Percentile percentile = new Percentile();

        goodPercentile() {
        }

        public void setQuantile(double quantile) {
            this.percentile.setQuantile(quantile);
        }

        public double evaluate(double[] values, int begin, int length) {
            return this.percentile.evaluate(values, begin, length);
        }

        public double evaluate(double[] values) {
            return this.percentile.evaluate(values);
        }

        public UnivariateStatistic copy() {
            goodPercentile result = new goodPercentile();
            result.setQuantile(this.percentile.getQuantile());
            return result;
        }
    }

    static class deepMean
    implements UnivariateStatistic {
        deepMean() {
        }

        public double evaluate(double[] values, int begin, int length) {
            return 42.0;
        }

        public double evaluate(double[] values) {
            return 42.0;
        }

        public UnivariateStatistic copy() {
            return new deepMean();
        }
    }
}

