/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.descriptive.moment.VectorialCovariance;
import org.junit.Assert;
import org.junit.Test;

public class VectorialCovarianceTest {
    private double[][] points = new double[][]{{1.2, 2.3, 4.5}, {-0.7, 2.3, 5.0}, {3.1, 0.0, -3.1}, {6.0, 1.2, 4.2}, {-0.7, 2.3, 5.0}};

    @Test
    public void testMismatch() {
        try {
            new VectorialCovariance(8, true).increment(new double[5]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dme) {
            Assert.assertEquals((Object)5, (Object)dme.getArgument());
            Assert.assertEquals((long)8L, (long)dme.getDimension());
        }
    }

    @Test
    public void testSimplistic() {
        VectorialCovariance stat = new VectorialCovariance(2, true);
        stat.increment(new double[]{-1.0, 1.0});
        stat.increment(new double[]{1.0, -1.0});
        RealMatrix c = stat.getResult();
        Assert.assertEquals((double)2.0, (double)c.getEntry(0, 0), (double)1.0E-12);
        Assert.assertEquals((double)-2.0, (double)c.getEntry(1, 0), (double)1.0E-12);
        Assert.assertEquals((double)2.0, (double)c.getEntry(1, 1), (double)1.0E-12);
    }

    @Test
    public void testBasicStats() {
        VectorialCovariance stat = new VectorialCovariance(this.points[0].length, true);
        for (int i = 0; i < this.points.length; ++i) {
            stat.increment(this.points[i]);
        }
        Assert.assertEquals((long)this.points.length, (long)stat.getN());
        RealMatrix c = stat.getResult();
        double[][] refC = new double[][]{{8.047, -1.9195, -3.4445}, {-1.9195, 1.047, 3.2795}, {-3.4445, 3.2795, 12.207}};
        for (int i = 0; i < c.getRowDimension(); ++i) {
            for (int j = 0; j <= i; ++j) {
                Assert.assertEquals((double)refC[i][j], (double)c.getEntry(i, j), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testSerial() {
        VectorialCovariance stat = new VectorialCovariance(this.points[0].length, true);
        Assert.assertEquals((Object)stat, (Object)TestUtils.serializeAndRecover(stat));
    }
}

