/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.distribution;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.exception.MathInternalError;
import org.apache.commons.math4.legacy.exception.NumberIsTooLargeException;
import org.apache.commons.math4.legacy.exception.OutOfRangeException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InverseTransformDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;
import org.apache.commons.statistics.distribution.DiscreteDistribution;

public abstract class AbstractIntegerDistribution
implements DiscreteDistribution {
    public double probability(int x0, int x1) throws NumberIsTooLargeException {
        if (x1 < x0) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)x0, (Number)x1, true);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    public int inverseCumulativeProbability(double p) throws OutOfRangeException {
        boolean chebyshevApplies;
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException((Number)p, (Number)0, (Number)1);
        }
        int lower = this.getSupportLowerBound();
        if (p == 0.0) {
            return lower;
        }
        if (lower == Integer.MIN_VALUE) {
            if (this.checkedCumulativeProbability(lower) >= p) {
                return lower;
            }
        } else {
            --lower;
        }
        int upper = this.getSupportUpperBound();
        if (p == 1.0) {
            return upper;
        }
        double mu = this.getMean();
        double sigma = JdkMath.sqrt((double)this.getVariance());
        boolean bl = chebyshevApplies = !Double.isInfinite(mu) && !Double.isNaN(mu) && !Double.isInfinite(sigma) && !Double.isNaN(sigma) && sigma != 0.0;
        if (chebyshevApplies) {
            double k = JdkMath.sqrt((double)((1.0 - p) / p));
            double tmp = mu - k * sigma;
            if (tmp > (double)lower) {
                lower = (int)JdkMath.ceil((double)tmp) - 1;
            }
            if ((tmp = mu + (k = 1.0 / k) * sigma) < (double)upper) {
                upper = (int)JdkMath.ceil((double)tmp) - 1;
            }
        }
        return this.solveInverseCumulativeProbability(p, lower, upper);
    }

    protected int solveInverseCumulativeProbability(double p, int lower, int upper) {
        while (lower + 1 < upper) {
            double pm;
            int xm = (lower + upper) / 2;
            if (xm < lower || xm > upper) {
                xm = lower + (upper - lower) / 2;
            }
            if ((pm = this.checkedCumulativeProbability(xm)) >= p) {
                upper = xm;
                continue;
            }
            lower = xm;
        }
        return upper;
    }

    private double checkedCumulativeProbability(int argument) throws MathInternalError {
        double result = this.cumulativeProbability(argument);
        if (Double.isNaN(result)) {
            throw new MathInternalError((Localizable)LocalizedFormats.DISCRETE_CUMULATIVE_PROBABILITY_RETURNED_NAN, new Object[]{argument});
        }
        return result;
    }

    public double logProbability(int x) {
        return JdkMath.log((double)this.probability(x));
    }

    public static int[] sample(int n, DiscreteDistribution.Sampler sampler) {
        int[] samples = new int[n];
        for (int i = 0; i < n; ++i) {
            samples[i] = sampler.sample();
        }
        return samples;
    }

    public DiscreteDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((SharedStateDiscreteSampler)InverseTransformDiscreteSampler.of((UniformRandomProvider)rng, this::inverseCumulativeProbability)).sample();
    }
}

