/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.interval;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.stat.interval.BinomialConfidenceInterval;
import org.apache.commons.math4.legacy.stat.interval.ConfidenceInterval;
import org.apache.commons.math4.legacy.stat.interval.IntervalUtils;
import org.apache.commons.statistics.distribution.NormalDistribution;

public class AgrestiCoullInterval
implements BinomialConfidenceInterval {
    @Override
    public ConfidenceInterval createInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        IntervalUtils.checkParameters(numberOfTrials, numberOfSuccesses, confidenceLevel);
        double alpha = (1.0 - confidenceLevel) / 2.0;
        NormalDistribution normalDistribution = NormalDistribution.of((double)0.0, (double)1.0);
        double z = normalDistribution.inverseSurvivalProbability(alpha);
        double zSquared = JdkMath.pow((double)z, (double)2.0);
        double modifiedNumberOfTrials = (double)numberOfTrials + zSquared;
        double modifiedSuccessesRatio = 1.0 / modifiedNumberOfTrials * ((double)numberOfSuccesses + 0.5 * zSquared);
        double difference = z * JdkMath.sqrt((double)(1.0 / modifiedNumberOfTrials * modifiedSuccessesRatio * (1.0 - modifiedSuccessesRatio)));
        return new ConfidenceInterval(modifiedSuccessesRatio - difference, modifiedSuccessesRatio + difference, confidenceLevel);
    }
}

