/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.creadur.tentacles.filter.Filters;

public class FileSystem {
    private final Filters filters = new Filters();

    public List<File> legalDocumentsUndeclaredIn(File contents) {
        return this.collect(contents, this.filters.legalDocumentsUndeclaredIn(contents));
    }

    public List<File> legalDocumentsDeclaredIn(File contents) {
        return this.collect(contents, this.filters.legalDocumentsDeclaredIn(contents));
    }

    public List<File> collect(File dir, String regex) {
        return this.collect(dir, Pattern.compile(regex));
    }

    private List<File> collect(File dir, final Pattern pattern) {
        return this.collect(dir, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return pattern.matcher(file.getAbsolutePath()).matches();
            }
        });
    }

    public List<File> collect(File dir, FileFilter filter) {
        File[] files;
        ArrayList<File> accepted = new ArrayList<File>();
        if (filter.accept(dir)) {
            accepted.add(dir);
        }
        if ((files = dir.listFiles()) != null) {
            for (File file : files) {
                accepted.addAll(this.collect(file, filter));
            }
        }
        return accepted;
    }

    public void mkparent(File file) {
        this.mkdirs(file.getParentFile());
    }

    public void mkdirs(File file) {
        if (!file.exists()) {
            boolean success = file.mkdirs();
            assert (success) : "mkdirs failed to create " + file;
            return;
        }
        boolean isDirectory = file.isDirectory();
        assert (isDirectory) : "Not a directory: " + file;
    }

    public List<File> documentsFrom(File repository) {
        return this.collect(repository, this.filters.filesOnly());
    }

    public List<File> licensesFrom(File directory) {
        return this.collect(directory, this.filters.licensesOnly());
    }

    public List<File> noticesOnly(File directory) {
        return this.collect(directory, this.filters.noticesOnly());
    }

    public List<File> licensesDeclaredIn(File contents) {
        return this.collect(contents, this.filters.licensesDeclaredIn(contents));
    }

    public List<File> noticesDeclaredIn(File contents) {
        return this.collect(contents, this.filters.noticesDeclaredIn(contents));
    }

    public List<File> archivesInPath(File file, String fileRepositoryPathNameFilter) {
        return this.collect(file, this.filters.archivesInPath(fileRepositoryPathNameFilter));
    }
}

