/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.config;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.utils.BufferHelper;

public class PersistedConnector
implements EncodingSupport {
    private long storeId;
    private String url;
    private String name;

    public PersistedConnector() {
    }

    public PersistedConnector(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public void setStoreId(long id) {
        this.storeId = id;
    }

    public long getStoreId() {
        return this.storeId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getEncodeSize() {
        int size = 0;
        size += BufferHelper.sizeOfString((String)this.name);
        return size += BufferHelper.sizeOfString((String)this.url);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeString(this.name);
        buffer.writeString(this.url);
    }

    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readString();
        this.url = buffer.readString();
    }

    public String toString() {
        return "PersistedConnector [storeId=" + this.storeId + ", name=" + this.name + ", url=" + this.url + "]";
    }
}

