/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.systest.microprofile.rest.client.regex;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;

@Path("/bookstore")
public interface BookStoreClient {

    // Only books with id consisting of 3 or 4 digits of the numbers between 5 and 9 are accepted
    @POST
    @Path("/echoxmlbookregex/{id : [5-9]{3,4}}")
    @Consumes("application/xml")
    @Produces("application/xml")
    Book echoXmlBookregex(Book book, @PathParam("id") String id);
    
    @POST
    @Path("/echoxmlbookregex/{id : [5-9]{3,4}}/{language:en|fr}/{format:pdf|epub|mobi}/many")
    @Consumes("application/xml")
    @Produces("application/xml")
    Book echoXmlBookregexMany(Book book, @PathParam("id") String id, 
        @PathParam("language") String language, @PathParam("format") String format);

}