/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.parsers.NameFormDescriptionSchemaParser;
import org.apache.directory.api.util.Strings;

public final class NameFormDescriptionSyntaxChecker
extends SyntaxChecker {
    private transient NameFormDescriptionSchemaParser schemaParser = new NameFormDescriptionSchemaParser();
    public static final NameFormDescriptionSyntaxChecker INSTANCE = new NameFormDescriptionSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.35");

    private NameFormDescriptionSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        try {
            this.schemaParser.parse(strValue);
            return true;
        }
        catch (ParseException pe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<NameFormDescriptionSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.35");
        }

        @Override
        public NameFormDescriptionSyntaxChecker build() {
            return new NameFormDescriptionSyntaxChecker(this.oid);
        }
    }
}

