/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class DnSyntaxChecker
extends SyntaxChecker {
    public static final DnSyntaxChecker INSTANCE = new DnSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.12");

    private DnSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
            }
            return true;
        }
        boolean result = Dn.isValid(strValue);
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
            } else {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<DnSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.12");
        }

        @Override
        public DnSyntaxChecker build() {
            return new DnSyntaxChecker(this.oid);
        }
    }
}

