/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.modules;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.felix.atomos.impl.modules.AtomosModules;
import org.osgi.framework.connect.ConnectContent;

public class ConnectContentModule
implements ConnectContent {
    final Module module;
    final ModuleReference reference;
    final AtomosModules.AtomosLayerModules atomosLayer;
    final Supplier<Optional<Map<String, String>>> headers;
    volatile ModuleReader reader = null;

    public ConnectContentModule(Module module, ModuleReference reference, AtomosModules.AtomosLayerModules atomosLayer, Supplier<Optional<Map<String, String>>> headers) {
        this.module = module;
        this.reference = reference;
        this.atomosLayer = atomosLayer;
        this.headers = headers;
    }

    public void open() throws IOException {
        this.reader = this.reference.open();
    }

    public void close() throws IOException {
        ModuleReader current = this.reader;
        if (current != null) {
            this.reader = null;
            current.close();
        }
    }

    public Optional<ClassLoader> getClassLoader() {
        return Optional.ofNullable(this.module.getClassLoader());
    }

    public Iterable<String> getEntries() throws IOException {
        return () -> {
            try {
                return this.currentReader().list().iterator();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private ModuleReader currentReader() throws IOException {
        ModuleReader current = this.reader;
        if (current == null) {
            throw new IOException("Reader is not open.");
        }
        return current;
    }

    public Optional<ConnectContent.ConnectEntry> getEntry(String name) {
        try {
            return this.currentReader().find(name).map(u -> new ModuleConnectEntry(name, (URI)u));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Optional<Map<String, String>> getHeaders() {
        return this.headers.get();
    }

    class ModuleConnectEntry
    implements ConnectContent.ConnectEntry {
        final String name;
        final URI uri;

        public ModuleConnectEntry(String name, URI uri) {
            this.name = name;
            this.uri = uri;
        }

        public long getContentLength() {
            try {
                return this.uri.toURL().openConnection().getContentLengthLong();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        public InputStream getInputStream() throws IOException {
            return ConnectContentModule.this.currentReader().open(this.name).get();
        }

        public long getLastModified() {
            try {
                return this.uri.toURL().openConnection().getDate();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        public String getName() {
            return this.name;
        }
    }
}

