/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect.launch;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.apache.felix.connect.felix.framework.util.MapToDictionary;
import org.apache.felix.connect.launch.BundleDescriptor;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;

public class ClasspathScanner {
    public List<BundleDescriptor> scanForBundles() throws Exception {
        return this.scanForBundles(null, null);
    }

    public List<BundleDescriptor> scanForBundles(ClassLoader loader) throws Exception {
        return this.scanForBundles(null, loader);
    }

    public List<BundleDescriptor> scanForBundles(String filterString) throws Exception {
        return this.scanForBundles(filterString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BundleDescriptor> scanForBundles(String filterString, ClassLoader loader) throws Exception {
        Filter filter = filterString != null ? FrameworkUtil.createFilter(filterString) : null;
        loader = loader != null ? loader : this.getClass().getClassLoader();
        ArrayList<BundleDescriptor> bundles = new ArrayList<BundleDescriptor>();
        byte[] bytes = new byte[0x200000];
        Enumeration<URL> e = loader.getResources("META-INF/MANIFEST.MF");
        while (e.hasMoreElements()) {
            URL manifestURL = e.nextElement();
            InputStream input = null;
            try {
                input = manifestURL.openStream();
                int size = 0;
                int i = input.read(bytes);
                while (i != -1) {
                    if ((size += i) == bytes.length) {
                        byte[] tmp = new byte[size * 2];
                        System.arraycopy(bytes, 0, tmp, 0, bytes.length);
                        bytes = tmp;
                    }
                    i = input.read(bytes, size, bytes.length - size);
                }
                String key = null;
                int last = 0;
                int current = 0;
                HashMap<String, String> headers = new HashMap<String, String>();
                for (int i2 = 0; i2 < size; ++i2) {
                    if (bytes[i2] == 13 && i2 + 1 < size && bytes[i2 + 1] == 10) continue;
                    if (bytes[i2] == 10 && i2 + 1 < size && bytes[i2 + 1] == 32) {
                        ++i2;
                        continue;
                    }
                    if (key == null && bytes[i2] == 58) {
                        key = new String(bytes, last, current - last, "UTF-8");
                        if (i2 + 1 < size && bytes[i2 + 1] == 32) {
                            last = current + 1;
                            continue;
                        }
                        throw new Exception("Manifest error: Missing space separator - " + key);
                    }
                    if (bytes[i2] == 10) {
                        if (last == current && key == null) break;
                        String value = new String(bytes, last, current - last, "UTF-8");
                        if (key == null) {
                            throw new Exception("Manifst error: Missing attribute name - " + value);
                        }
                        if (headers.put(key, value) != null) {
                            throw new Exception("Manifst error: Duplicate attribute name - " + key);
                        }
                        last = current;
                        key = null;
                        continue;
                    }
                    bytes[current++] = bytes[i2];
                }
                if (filter != null && !filter.match(new MapToDictionary(headers))) continue;
                bundles.add(new BundleDescriptor(loader, this.getParentURL(manifestURL).toExternalForm(), headers));
            }
            finally {
                if (input == null) continue;
                input.close();
            }
        }
        return bundles;
    }

    private URL getParentURL(URL url) throws Exception {
        String externalForm = url.toExternalForm();
        return new URL(externalForm.substring(0, externalForm.length() - "META-INF/MANIFEST.MF".length()));
    }
}

