/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.server;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.httplite.osgi.Logger;
import org.apache.felix.httplite.server.Connection;
import org.apache.felix.httplite.server.ThreadGate;

public class ThreadPool {
    public static final int DEFAULT_THREAD_TIMEOUT = 60000;
    private final int m_threadTimeout;
    private final ThreadGroup m_group = new ThreadGroup("ThreadPoolGroup");
    private int m_state;
    private ThreadGate m_shutdownGate;
    private int m_threadName = 0;
    private int m_threadLimit = 0;
    private int m_threadCount = 0;
    private int m_threadAvailable = 0;
    private final List m_connectionList = new ArrayList();
    private final Logger m_logger;

    public ThreadPool(int threadLimit, Logger logger) {
        this(threadLimit, 60000, logger);
    }

    public ThreadPool(int threadLimit, int threadTimeout, Logger logger) {
        this.m_threadLimit = threadLimit;
        this.m_threadTimeout = threadTimeout;
        this.m_logger = logger;
        this.m_state = 0;
    }

    public synchronized int getState() {
        return this.m_state;
    }

    public synchronized void start() {
        if (this.m_state == 2) {
            throw new IllegalStateException("Thread pool is in process of stopping.");
        }
        this.m_state = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        ThreadGate gate = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.m_state != 0) {
                if (this.m_shutdownGate == null && this.m_threadCount > 0) {
                    this.m_shutdownGate = new ThreadGate();
                }
                gate = this.m_shutdownGate;
                this.m_state = 2;
                this.m_group.interrupt();
            }
        }
        if (gate != null) {
            gate.await();
        }
    }

    public synchronized void addConnection(Connection connection) {
        if (this.m_state == 1) {
            this.m_connectionList.add(connection);
            this.notify();
            if (this.m_threadAvailable < this.m_connectionList.size() && this.m_threadCount < this.m_threadLimit) {
                ++this.m_threadCount;
                this.m_threadName = this.m_threadName == Integer.MAX_VALUE ? 1 : ++this.m_threadName;
                new Thread(this.m_group, new Runnable(){

                    public void run() {
                        ThreadPool.this.processConnections();
                    }
                }, Integer.toString(this.m_threadName)).start();
                this.m_logger.log(4, "Created new thread for pool; count = " + this.m_threadCount + ", max = " + this.m_threadLimit + ".");
            }
        } else {
            throw new IllegalStateException("The thread pool is not active.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnections() {
        while (true) {
            Connection connection;
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                ++this.m_threadAvailable;
                try {
                    long start;
                    long current = start = System.currentTimeMillis();
                    while (this.m_state == 1 && this.m_connectionList.size() == 0 && (this.m_threadTimeout == 0 || current - start < (long)this.m_threadTimeout)) {
                        this.wait((long)this.m_threadTimeout - (current - start));
                        current = System.currentTimeMillis();
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                connection = this.m_connectionList.size() == 0 ? null : (Connection)this.m_connectionList.remove(0);
                --this.m_threadAvailable;
                if (connection == null) {
                    --this.m_threadCount;
                    if (Thread.interrupted()) {
                        this.m_logger.log(4, "Pool thread dying due to interrupt.");
                    } else {
                        this.m_logger.log(4, "Pool thread dying due to inactivity.");
                    }
                    if (this.m_state == 2 && this.m_threadCount == 0) {
                        this.m_shutdownGate.open();
                        this.m_shutdownGate = null;
                        this.m_state = 0;
                        this.m_logger.log(4, "Server shutdown complete.");
                    }
                    return;
                }
            }
            try {
                connection.process();
                this.m_logger.log(4, "Connection closed normally.");
                continue;
            }
            catch (SocketTimeoutException ex) {
                this.m_logger.log(3, "Connection closed due to inactivity.");
                continue;
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Connection close due to unknown reason.", ex);
                continue;
            }
            break;
        }
    }
}

