/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make.coverage;

import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Clazz;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coverage {
    public static Map<Clazz.MethodDef, List<Clazz.MethodDef>> getCrossRef(Collection<Clazz> source, Collection<Clazz> dest) throws Exception {
        Map<Clazz.MethodDef, List<Clazz.MethodDef>> catalog = Coverage.buildCatalog(dest);
        Coverage.crossRef(source, catalog);
        return catalog;
    }

    private static void crossRef(Collection<Clazz> source, final Map<Clazz.MethodDef, List<Clazz.MethodDef>> catalog) throws Exception {
        for (final Clazz clazz : source) {
            clazz.parseClassFileWithCollector(new ClassDataCollector(){
                Clazz.MethodDef source;

                public void implementsInterfaces(String[] names) {
                    Clazz.MethodDef def = new Clazz.MethodDef(0, clazz.getFQN(), "<implements>", "()V");
                    String[] stringArray = names;
                    int n = names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String interfaceName = stringArray[n2];
                        interfaceName = Clazz.internalToFqn(interfaceName);
                        for (Map.Entry entry : catalog.entrySet()) {
                            String catalogClass = ((Clazz.MethodDef)entry.getKey()).clazz;
                            List references = (List)entry.getValue();
                            if (!catalogClass.equals(interfaceName)) continue;
                            references.add(def);
                        }
                        ++n2;
                    }
                }

                public void method(Clazz.MethodDef source) {
                    this.source = source;
                }

                public void reference(Clazz.MethodDef reference) {
                    List references = (List)catalog.get(reference);
                    if (references != null) {
                        references.add(this.source);
                    }
                }
            });
        }
    }

    private static Map<Clazz.MethodDef, List<Clazz.MethodDef>> buildCatalog(Collection<Clazz> sources) throws Exception {
        final TreeMap<Clazz.MethodDef, List<Clazz.MethodDef>> catalog = new TreeMap<Clazz.MethodDef, List<Clazz.MethodDef>>();
        for (final Clazz clazz : sources) {
            clazz.parseClassFileWithCollector(new ClassDataCollector(){

                public boolean classStart(int access, String name) {
                    return clazz.isPublic();
                }

                public void method(Clazz.MethodDef source) {
                    if (Modifier.isPublic(source.access) || Modifier.isProtected(source.access)) {
                        catalog.put(source, new ArrayList());
                    }
                }
            });
        }
        return catalog;
    }
}

