/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.test;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import junit.framework.Assert;
import org.w3c.dom.Document;

public class XmlTester {
    static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    static final XPathFactory xpathf = XPathFactory.newInstance();
    static final DocumentBuilder db;
    final Document document;
    final XPath xpath = xpathf.newXPath();

    static {
        try {
            dbf.setNamespaceAware(true);
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public XmlTester(InputStream in, final String ... namespace) throws Exception {
        this.xpath.setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return Arrays.asList("md", "scr").iterator();
            }

            public String getPrefix(String namespaceURI) {
                int i = 0;
                while (i < namespace.length) {
                    if (namespaceURI.equals(namespace[i + 1])) {
                        return namespace[i];
                    }
                    i += 2;
                }
                return null;
            }

            public String getNamespaceURI(String prefix) {
                int i = 0;
                while (i < namespace.length) {
                    if (prefix.equals(namespace[i])) {
                        return namespace[i + 1];
                    }
                    i += 2;
                }
                return null;
            }
        });
        this.document = db.parse(in);
    }

    public void assertAttribute(String value, String expr) throws XPathExpressionException {
        System.out.println(expr);
        String o = (String)this.xpath.evaluate(expr, this.document, XPathConstants.STRING);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)value, (String)o);
    }
}

