/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.command;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.felix.gogo.command.Base64Encoder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final StringBuffer m_sb = new StringBuffer();

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name + " (" + Long.toString(bundle.getBundleId()) + ")";
        }
        return "[STALE BUNDLE]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUnderlineString(int len) {
        StringBuffer stringBuffer = m_sb;
        synchronized (stringBuffer) {
            m_sb.delete(0, m_sb.length());
            for (int i = 0; i < len; ++i) {
                m_sb.append('-');
            }
            return m_sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getValueString(Object obj) {
        StringBuffer stringBuffer = m_sb;
        synchronized (stringBuffer) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof String[]) {
                String[] array = (String[])obj;
                m_sb.delete(0, m_sb.length());
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        m_sb.append(", ");
                    }
                    m_sb.append(array[i].toString());
                }
                return m_sb.toString();
            }
            if (obj instanceof Boolean) {
                return ((Boolean)obj).toString();
            }
            if (obj instanceof Long) {
                return ((Long)obj).toString();
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).toString();
            }
            if (obj instanceof Short) {
                return ((Short)obj).toString();
            }
            if (obj instanceof Double) {
                return ((Double)obj).toString();
            }
            if (obj instanceof Float) {
                return ((Float)obj).toString();
            }
            if (obj == null) {
                return "null";
            }
            return obj.toString();
        }
    }

    public static <T> T getService(BundleContext bc, Class<T> clazz, List<ServiceReference> refs) {
        ServiceReference ref = bc.getServiceReference(clazz.getName());
        if (ref == null) {
            return null;
        }
        Object t = bc.getService(ref);
        if (t != null) {
            refs.add(ref);
        }
        return (T)t;
    }

    public static void ungetServices(BundleContext bc, List<ServiceReference> refs) {
        while (refs.size() > 0) {
            bc.ungetService(refs.remove(0));
        }
    }

    public static void downloadSource(PrintStream out, PrintStream err, URL srcURL, File localDir, boolean extract) {
        String fileName = srcURL.getFile().lastIndexOf(47) > 0 ? srcURL.getFile().substring(srcURL.getFile().lastIndexOf(47) + 1) : srcURL.getFile();
        try {
            out.println("Connecting...");
            if (!localDir.exists()) {
                err.println("Destination directory does not exist.");
            }
            File file = new File(localDir, fileName);
            FileOutputStream os = new FileOutputStream(file);
            URLConnection conn = srcURL.openConnection();
            Util.setProxyAuth(conn);
            int total = conn.getContentLength();
            InputStream is = conn.getInputStream();
            if (total > 0) {
                out.println("Downloading " + fileName + " ( " + total + " bytes ).");
            } else {
                out.println("Downloading " + fileName + ".");
            }
            byte[] buffer = new byte[4096];
            int count = 0;
            int len = is.read(buffer);
            while (len > 0) {
                count += len;
                ((OutputStream)os).write(buffer, 0, len);
                len = is.read(buffer);
            }
            ((OutputStream)os).close();
            is.close();
            if (extract) {
                is = new FileInputStream(file);
                JarInputStream jis = new JarInputStream(is);
                out.println("Extracting...");
                Util.unjar(jis, localDir);
                jis.close();
                file.delete();
            }
        }
        catch (Exception ex) {
            err.println(ex);
        }
    }

    public static void unjar(JarInputStream jis, File dir) throws IOException {
        byte[] buffer = new byte[4096];
        JarEntry je = jis.getNextJarEntry();
        while (je != null) {
            if (je.getName().startsWith("/")) {
                throw new IOException("JAR resource cannot contain absolute paths.");
            }
            File target = new File(dir, je.getName());
            if (je.isDirectory()) {
                if (!target.exists() && !target.mkdirs()) {
                    throw new IOException("Unable to create target directory: " + target);
                }
            } else {
                int lastIndex = je.getName().lastIndexOf(47);
                String name = lastIndex >= 0 ? je.getName().substring(lastIndex + 1) : je.getName();
                String destination = lastIndex >= 0 ? je.getName().substring(0, lastIndex) : "";
                destination = destination.replace('/', File.separatorChar);
                Util.copy(jis, dir, name, destination, buffer);
            }
            je = jis.getNextJarEntry();
        }
    }

    public static void copy(InputStream is, File dir, String destName, String destDir, byte[] buffer) throws IOException {
        File targetDir;
        if (destDir == null) {
            destDir = "";
        }
        if (!(targetDir = new File(dir, destDir)).exists()) {
            if (!targetDir.mkdirs()) {
                throw new IOException("Unable to create target directory: " + targetDir);
            }
        } else if (!targetDir.isDirectory()) {
            throw new IOException("Target is not a directory: " + targetDir);
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(targetDir, destName)));
        int count = 0;
        while ((count = is.read(buffer)) > 0) {
            bos.write(buffer, 0, count);
        }
        bos.close();
    }

    public static void setProxyAuth(URLConnection conn) throws IOException {
        String auth = System.getProperty("http.proxyAuth");
        if (auth != null && auth.length() > 0 && ("http".equals(conn.getURL().getProtocol()) || "https".equals(conn.getURL().getProtocol()))) {
            String base64 = Base64Encoder.base64Encode(auth);
            conn.setRequestProperty("Proxy-Authorization", "Basic " + base64);
        }
    }

    public static InputStream openURL(URL url) throws IOException {
        return Util.openURL(url.openConnection());
    }

    public static InputStream openURL(URLConnection conn) throws IOException {
        Util.setProxyAuth(conn);
        return conn.getInputStream();
    }

    public static List<String> parseSubstring(String value) {
        ArrayList<String> pieces = new ArrayList<String>();
        StringBuffer ss = new StringBuffer();
        boolean wasStar = false;
        boolean leftstar = false;
        boolean rightstar = false;
        int idx = 0;
        boolean escaped = false;
        while (true) {
            if (idx >= value.length()) {
                if (wasStar) {
                    rightstar = true;
                    break;
                }
                pieces.add(ss.toString());
                break;
            }
            char c = value.charAt(idx++);
            if (!(escaped || c != '(' && c != ')')) {
                throw new IllegalArgumentException("Illegal value: " + value);
            }
            if (!escaped && c == '*') {
                if (wasStar) {
                    throw new IllegalArgumentException("Invalid filter string: " + value);
                }
                if (ss.length() > 0) {
                    pieces.add(ss.toString());
                }
                ss.setLength(0);
                if (pieces.isEmpty()) {
                    leftstar = true;
                }
                wasStar = true;
                continue;
            }
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            escaped = false;
            wasStar = false;
            ss.append(c);
        }
        ss.setLength(0);
        if (leftstar || rightstar || pieces.size() > 1) {
            if (rightstar) {
                pieces.add("");
            }
            if (leftstar) {
                pieces.add(0, "");
            }
        }
        return pieces;
    }

    public static String unparseSubstring(List<String> pieces) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pieces.size(); ++i) {
            if (i > 0) {
                sb.append("*");
            }
            sb.append(pieces.get(i));
        }
        return sb.toString();
    }

    public static boolean compareSubstring(List<String> pieces, String s) {
        boolean result = true;
        int len = pieces.size();
        if (len == 1) {
            return s.equals(pieces.get(0));
        }
        int index = 0;
        for (int i = 0; i < len; ++i) {
            String piece = pieces.get(i);
            if (i == 0 && !s.startsWith(piece)) {
                result = false;
                break;
            }
            if (i == len - 1) {
                if (s.endsWith(piece)) {
                    result = true;
                    break;
                }
                result = false;
                break;
            }
            if (i > 0 && i < len - 1 && (index = s.indexOf(piece, index)) < 0) {
                result = false;
                break;
            }
            index += piece.length();
        }
        return result;
    }
}

