/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.ArrayList;
import java.util.Dictionary;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.InstanceStateListener;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

public class HandlerManager
extends InstanceManager {
    private Handler m_handler;

    public HandlerManager(ComponentFactory factory, BundleContext context, HandlerManager[] handlers) {
        super(factory, context, handlers);
    }

    public Handler getHandler() {
        if (this.m_handler == null) {
            this.createHandlerObject();
        }
        return this.m_handler;
    }

    public void init(ComponentInstance instance, Element metadata, Dictionary configuration) throws ConfigurationException {
        this.createHandlerObject();
        this.m_handler.setFactory(instance.getFactory());
        this.m_handler.attach(instance);
        this.m_handler.configure(metadata, configuration);
    }

    private void createHandlerObject() {
        if (this.m_handler != null) {
            return;
        }
        this.m_handler = (Handler)this.createPojoObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createPojoObject() {
        Object instance = this.createObject();
        HandlerManager handlerManager = this;
        synchronized (handlerManager) {
            if (this.m_pojoObjects == null) {
                this.m_pojoObjects = new ArrayList(1);
            }
            this.m_pojoObjects.add(instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        int i;
        HandlerManager handlerManager = this;
        synchronized (handlerManager) {
            if (this.m_state != 0) {
                return;
            }
            this.m_state = -2;
        }
        for (i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].addInstanceStateListener(this);
            this.m_handlers[i].start();
        }
        for (i = 0; i < this.m_handlers.length; ++i) {
            ((PrimitiveHandler)this.m_handlers[i].getHandler()).onCreation(this.m_handler);
        }
        this.m_handler.start();
        for (i = 0; i < this.m_handlers.length; ++i) {
            if (this.m_handlers[i].getHandler().isValid()) continue;
            this.setState(1);
            return;
        }
        if (this.m_handler.getValidity()) {
            this.setState(2);
        } else {
            this.setState(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HandlerManager handlerManager = this;
        synchronized (handlerManager) {
            if (this.m_state == 0) {
                return;
            }
            this.m_state = -2;
        }
        this.setState(1);
        if (this.m_handler != null) {
            this.m_handler.stop();
        }
        for (int i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].removeInstanceStateListener(this);
            this.m_handlers[i].stop();
        }
        ArrayList listeners = null;
        HandlerManager handlerManager2 = this;
        synchronized (handlerManager2) {
            this.m_state = 0;
            if (this.m_listeners != null) {
                listeners = new ArrayList(this.m_listeners);
            }
        }
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                ((InstanceStateListener)listeners.get(i)).stateChanged(this, 0);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.m_handler = null;
    }

    protected void kill() {
        super.dispose();
        this.m_handler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ComponentInstance instance, int newState) {
        int state;
        HandlerManager handlerManager = this;
        synchronized (handlerManager) {
            if (this.m_state <= 0) {
                return;
            }
            state = this.m_state;
        }
        if (newState == 1 && state == 2) {
            this.setState(1);
            return;
        }
        if (newState == 2 && state == 1) {
            if (!this.m_handler.getValidity()) {
                return;
            }
            for (int i = 0; i < this.m_handlers.length; ++i) {
                if (this.m_handlers[i].getState() == 2) continue;
                return;
            }
            this.setState(2);
            return;
        }
    }
}

