/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.threaddump.internal.jdk6;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.apache.felix.threaddump.internal.ThreadWriter;
import org.apache.felix.threaddump.internal.jdk5.Jdk15ThreadDumper;

public final class Jdk16ThreadDumper
extends Jdk15ThreadDumper {
    private static final String LOCKED = "\t- locked <0x{0}> (a {1})";
    private static final String BLOCKED = "\t- waiting to lock <0x{0}> (a {1}) owned by \"{2}\" tid=0x{3}";

    protected ThreadInfo[] getThreadInfo(ThreadMXBean threadMXBean) {
        return threadMXBean.dumpAllThreads(true, true);
    }

    protected long[] findDeadlockedThreads(ThreadMXBean threadMXBean) {
        return threadMXBean.findDeadlockedThreads();
    }

    protected void printStackTrace(ThreadWriter threadWriter, ThreadInfo info) {
        StackTraceElement[] trace = info.getStackTrace();
        if (trace.length > 0) {
            MonitorInfo[] locks = info.getLockedMonitors();
            int currentLock = 0;
            for (int idx = 0; idx < trace.length; ++idx) {
                LockInfo locked;
                threadWriter.printStackTraceElement(trace[idx]);
                if (idx == 0 && (locked = info.getLockInfo()) != null) {
                    Jdk16ThreadDumper.printLockInfo(threadWriter, BLOCKED, locked, info.getLockOwnerName(), info.getLockOwnerId());
                }
                if (currentLock >= locks.length || locks[currentLock].getLockedStackDepth() != idx) continue;
                Jdk16ThreadDumper.printLockInfo(threadWriter, LOCKED, locks[currentLock]);
                ++currentLock;
            }
            LockInfo[] syncs = info.getLockedSynchronizers();
            if (syncs != null && syncs.length > 0) {
                threadWriter.printEmptyLine();
                threadWriter.println("   Locked ownable synchronizers:");
                for (int j = 0; j < syncs.length; ++j) {
                    LockInfo sync = syncs[j];
                    Jdk16ThreadDumper.printLockInfo(threadWriter, LOCKED, sync);
                }
            }
        }
    }

    protected void printDeadlockedThreadInfo(ThreadWriter threadWriter, ThreadInfo info) {
        threadWriter.println("\"{0}\":", new Object[]{info.getThreadName()});
        threadWriter.println("  waiting to lock monitor {0} (object {1}, a {2}),", new Object[]{"7f8a5595d180", Integer.toHexString(info.getLockInfo().getIdentityHashCode()), info.getLockInfo().getClassName()});
        threadWriter.println("  which is held by \"{0}\"", new Object[]{info.getLockOwnerName()});
    }

    private static void printLockInfo(ThreadWriter threadWriter, String pattern, LockInfo lockInfo) {
        Jdk16ThreadDumper.printLockInfo(threadWriter, pattern, lockInfo, null, -1L);
    }

    private static void printLockInfo(ThreadWriter threadWriter, String pattern, LockInfo lockInfo, String lockOwnerName, long lockOwnerId) {
        threadWriter.println(pattern, new Object[]{Integer.toHexString(lockInfo.getIdentityHashCode()), lockInfo.getClassName(), lockOwnerName, lockOwnerId});
    }
}

