/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.concrete.DMessage;
import java.text.NumberFormat;

public class DMessageCache {
    public static final int MAX_CACHED_DATA_SIZE = 128;
    static DMessage[] m_cache = new DMessage[128];

    public static DMessage alloc(int size) {
        DMessage msg;
        int index = DMessageCache.size2Index(size);
        if (index < 0) {
            msg = new DMessage(size);
        } else if (m_cache[index] == null) {
            msg = new DMessage(size);
        } else {
            msg = m_cache[index];
            DMessageCache.m_cache[index] = null;
        }
        return msg;
    }

    private static String uft() {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        long used = total - free;
        NumberFormat nf = NumberFormat.getInstance();
        return ", used " + nf.format(used) + ", free " + nf.format(free) + ", total " + nf.format(total);
    }

    public static void free(DMessage msg) {
        int index = DMessageCache.size2Index(msg.getSize());
        msg.clear();
        if (index >= 0 && m_cache[index] == null) {
            DMessageCache.m_cache[index] = msg;
        }
    }

    public static int size2Index(int size) {
        return size < 128 ? size : -1;
    }
}

