/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.util.Trace;
import flex2.compiler.AssetInfo;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.LocalFilePathResolver;
import flex2.compiler.common.PathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbedUtil {
    public static Transcoder.TranscodingResults transcode(Transcoder[] transcoders, CompilationUnit unit, SymbolTable symbolTable, String className, Map<String, Object> args, int line, int col, boolean generateCode) {
        PathResolver context = new PathResolver();
        Transcoder.TranscodingResults results = null;
        Source source = unit.getSource();
        if (!args.containsKey("_resolvedSource")) {
            String embedSource = (String)args.get("source");
            if (embedSource != null && embedSource.charAt(0) == '/') {
                Object owner;
                VirtualFile pathRoot = source.getPathRoot();
                if (pathRoot != null) {
                    context.addSinglePathResolver(pathRoot);
                }
                if ((owner = source.getOwner()) instanceof SinglePathResolver) {
                    context.addSinglePathResolver((SinglePathResolver)owner);
                }
            } else {
                VirtualFile backingFile;
                if (args.containsKey("_file")) {
                    VirtualFile contextFile;
                    String path = (String)args.get("_file");
                    String pathSep = (String)args.get("_pathsep");
                    if ("true".equals(pathSep)) {
                        path = path.replace('/', '\\');
                    }
                    if ((contextFile = LocalFilePathResolver.getSingleton().resolve(path)) != null && !contextFile.getName().equals(source.getName())) {
                        context.addSinglePathResolver(contextFile);
                    }
                }
                if ((backingFile = source.getBackingFile()) != null) {
                    context.addSinglePathResolver(backingFile);
                }
            }
            context.addSinglePathResolver(ThreadLocalToolkit.getPathResolver());
        } else {
            context.addSinglePathResolver(LocalFilePathResolver.getSingleton());
        }
        if (!unit.hasAssets() || !unit.getAssets().contains(className)) {
            results = EmbedUtil.transcode(transcoders, symbolTable, className, args, line, col, generateCode, source, context);
            if (results != null) {
                List<Transcoder.TranscodingResults> additionalAssets;
                if (results.defineTag != null) {
                    unit.getAssets().add(className, new AssetInfo(results.defineTag, results.assetSource, results.modified, args));
                }
                if ((additionalAssets = results.additionalAssets) != null) {
                    for (int i = 0; i < additionalAssets.size(); ++i) {
                        Transcoder.TranscodingResults asset = additionalAssets.get(i);
                        if (asset.defineTag == null) continue;
                        unit.getAssets().add(asset.className, new AssetInfo(asset.defineTag, results.assetSource, results.modified, args));
                    }
                }
            }
        } else assert (false) : "Asset already added for " + className;
        return results;
    }

    public static Transcoder.TranscodingResults transcode(Transcoder[] transcoders, String className, Map<String, Object> args, int line, int col, boolean generateCode, Source s, PathResolver context) {
        return EmbedUtil.transcode(transcoders, null, className, args, line, col, generateCode, s, context);
    }

    private static Transcoder.TranscodingResults transcode(Transcoder[] transcoders, SymbolTable symbolTable, String className, Map<String, Object> args, int line, int col, boolean generateCode, Source s, PathResolver context) {
        String request = EmbedUtil.formatTranscodeRequest(args);
        Transcoder.TranscodingResults results = null;
        String mimeType = (String)args.get("mimeType");
        String origin = (String)args.get("_file");
        String pathSep = (String)args.get("_pathsep");
        if ("true".equals(pathSep)) {
            origin = origin.replace('/', '\\');
        }
        String nameForReporting = "";
        long mem = -1L;
        if (Trace.embed) {
            Trace.trace((String)("Transcoding " + request));
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().startTime("Transcoded " + request);
                mem = ThreadLocalToolkit.getBenchmark().peakMemoryUsage(false);
            }
        }
        try {
            Transcoder t;
            if (s != null) {
                if (origin == null) {
                    origin = s.getName();
                }
                nameForReporting = s.getNameForReporting();
            }
            if (mimeType == null) {
                if (args.containsKey("source")) {
                    String source = (String)args.get("source");
                    mimeType = MimeMappings.getMimeType(source);
                    if (mimeType == null) {
                        EmbedUtil.logTranscoderException(new TranscoderException.UnrecognizedExtension(request), nameForReporting, line, col);
                        return null;
                    }
                } else if (args.containsKey("skinClass")) {
                    mimeType = "skin";
                }
            }
            if ((t = EmbedUtil.getTranscoder(transcoders, mimeType)) == null) {
                EmbedUtil.logTranscoderException(new TranscoderException.NoMatchingTranscoder(mimeType), nameForReporting, line, col);
            } else {
                if (!args.containsKey("symbol") && !args.containsKey("exportSymbol")) {
                    args.put("exportSymbol", className);
                }
                results = t.transcode(context, symbolTable, args, className, generateCode);
            }
        }
        catch (TranscoderException transcoderException) {
            EmbedUtil.logTranscoderException(transcoderException, origin, line, col);
        }
        if (Trace.embed) {
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().stopTime("Transcoded " + request);
            }
            if (mem != -1L && ThreadLocalToolkit.getBenchmark() != null) {
                long endMem = ThreadLocalToolkit.getBenchmark().peakMemoryUsage(false);
                Trace.trace((String)("Increase in peak memory from transcoding: " + (endMem - mem) + " MB"));
            }
        }
        return results;
    }

    public static Transcoder getTranscoder(Transcoder[] transcoders, String mimeType) {
        assert (transcoders != null);
        for (int i = 0; i < transcoders.length; ++i) {
            if (!transcoders[i].isSupported(mimeType)) continue;
            return transcoders[i];
        }
        return null;
    }

    public static String formatTranscodeRequest(Map<String, Object> args) {
        String s = (String)args.get("source");
        if (s != null) {
            return s;
        }
        s = "[";
        Iterator<Map.Entry<String, Object>> it = args.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            s = s + e.getKey() + "='" + e.getValue() + "'";
            if (!it.hasNext()) continue;
            s = s + ", ";
        }
        s = s + "]";
        return s;
    }

    public static void logTranscoderException(TranscoderException transcoderException, String path, int line, int column) {
        transcoderException.path = path;
        transcoderException.line = line;
        transcoderException.column = column;
        ThreadLocalToolkit.log(transcoderException);
    }
}

