/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.builder.AnonymousObjectGraphBuilder;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.AnonymousObjectGraph;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;

class ModelBuilder
extends AnonymousObjectGraphBuilder {
    private Model parent;

    ModelBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document, Model parent) {
        super(unit, typeTable, mxmlConfiguration, document);
        this.parent = parent;
        this.setAllowTwoWayBind(true);
    }

    public void analyze(ModelNode node) {
        String classObjectProxy = NameFormatter.toDot(this.standardDefs.CLASS_OBJECTPROXY);
        this.document.addImport(classObjectProxy, node.beginLine);
        Type bindingClass = this.typeTable.getType(this.standardDefs.CLASS_OBJECTPROXY);
        if (bindingClass == null) {
            this.log(node, (CompilerMessage)new ClassNotFound(classObjectProxy));
        }
        this.graph = new AnonymousObjectGraph(this.document, bindingClass, node.beginLine);
        this.registerModel(node, (Model)this.graph, this.parent == null);
        if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
            CDATANode cdata = (CDATANode)node.getChildAt(0);
            if (cdata.image.length() > 0) {
                BindingExpression be = this.textParser.parseBindingExpression(cdata.image, cdata.beginLine);
                if (be != null) {
                    be.setDestination(this.graph);
                    be.setDestinationObjectProxy(true);
                } else {
                    this.log(cdata, (CompilerMessage)new OnlyScalarError((String)this.getLanguageAttributeValue(node, "id")));
                }
            }
        } else if (node.getChildCount() == 1) {
            this.processChildren((Node)node.getChildAt(0), this.graph);
        } else if (node.getChildCount() > 1) {
            this.log(node, (CompilerMessage)new OnlyOneRootTag());
        }
    }

    public static class OnlyOneRootTag
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8929223631634187913L;
    }

    public static class OnlyScalarError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -97448183610558564L;
        public String id;

        public OnlyScalarError(String id) {
            this.id = id;
        }
    }

    public static class ClassNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 1805035532862926349L;
        public String className;

        public ClassNotFound(String className) {
            this.className = className;
        }
    }
}

