/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.SwcExternalScriptInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SwcExternalScriptInfoImpl
implements SwcExternalScriptInfo {
    private String swcLocation;
    private Map<String, Set<String>> scriptToTypes = new TreeMap<String, Set<String>>();
    private Map<String, Set<String>> scriptToSwcs = new HashMap<String, Set<String>>();

    public SwcExternalScriptInfoImpl() {
    }

    public SwcExternalScriptInfoImpl(String swcLocation) {
        assert (swcLocation != null);
        this.swcLocation = swcLocation;
    }

    @Override
    public String getSwcLocation() {
        return this.swcLocation;
    }

    @Override
    public Set<String> getScriptDependencyTypes(String scriptName) {
        Set<String> dependencySet = this.scriptToTypes.get(scriptName);
        return dependencySet != null ? dependencySet : Collections.emptySet();
    }

    @Override
    public Set<String> getSwcDependencies(String scriptName) {
        Set<String> swcSet = this.scriptToSwcs.get(scriptName);
        return swcSet != null ? swcSet : Collections.emptySet();
    }

    @Override
    public Set<String> getExternalScripts() {
        return this.scriptToTypes != null ? this.scriptToTypes.keySet() : Collections.emptySet();
    }

    public void addScriptDependencyType(String scriptName, String dependencyType) {
        if (scriptName == null || dependencyType == null) {
            throw new NullPointerException();
        }
        Set<String> dependencySet = this.scriptToTypes.get(scriptName);
        if (dependencySet == null) {
            dependencySet = new HashSet<String>();
            this.scriptToTypes.put(scriptName, dependencySet);
        }
        dependencySet.add(dependencyType);
    }

    public void addResolvingSwc(String scriptName, String swcLocation) {
        if (scriptName == null || swcLocation == null) {
            throw new NullPointerException();
        }
        Set<String> swcSet = this.scriptToSwcs.get(scriptName);
        if (swcSet == null) {
            swcSet = new HashSet<String>();
            this.scriptToSwcs.put(scriptName, swcSet);
        }
        swcSet.add(swcLocation);
    }

    @Override
    public Set<String> getExternalScripts(String resolvedSwcLocation) {
        HashSet<String> externalScripts = new HashSet<String>();
        for (Map.Entry<String, Set<String>> scriptMap : this.scriptToSwcs.entrySet()) {
            Set<String> resolvingSwcs = scriptMap.getValue();
            if (resolvingSwcs == null || !resolvingSwcs.contains(resolvedSwcLocation)) continue;
            externalScripts.add(scriptMap.getKey());
        }
        return externalScripts;
    }
}

