/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.report;

import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.DateUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.report.Suite;

public class Report {
    private static final String FAILURE = "failure";
    private static final String ERROR = "error";
    private static final String IGNORE = "ignore";
    private static final String TEST_SUITE = "testsuite";
    private static final String NAME_ATTRIBUTE_LABEL = "name";
    private static final String FAILURE_ATTRIBUTE_LABEL = "failures";
    private static final String ERROR_ATTRIBUTE_LABEL = "errors";
    private static final String IGNORE_ATTRIBUTE_LABEL = "skipped";
    private static final String TIME_ATTRIBUTE_LABEL = "time";
    private static final String TESTS_ATTRIBUTE_LABEL = "tests";
    private static final String HOSTNAME_ATTRIBUTE_LABEL = "hostname";
    private static final String TIMESTAMP_ATTRIBUTE_LABEL = "timestamp";
    private static final String FILENAME_PREFIX = "TEST-";
    private static final String FILENAME_EXTENSION = ".xml";
    private static final String FAILED_TEST = "FlexUnit test {0} in suite {1} failed.";
    private static final String ERRORED_TEST = "FlexUnit test {0} in suite {1} had errors.";
    private static final String IGNORED_TEST = "FlexUnit test {0} in suite {1} was ignored.";
    private static final String TEST_INFO = "Suite: {0}\nTests run: {1}, Failures: {2}, Errors: {3}, Skipped: {4}, Time elapsed: {5} sec";
    private static final String ERROR_SAVING_REPORT = "Error saving report.";
    private static final String CLASSNAME_ATTRIBUTE = "classname";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String STATUS_ATTRIBUTE = "status";
    private static final String TIME_ATTRIBUTE = "time";
    protected Suite suite;
    private Document document;
    private List<String> recordedRuns = new ArrayList<String>();

    public Report(Suite suite) {
        this.suite = suite;
        this.document = DocumentHelper.createDocument();
        this.document.addElement(TEST_SUITE).addAttribute("name", suite.getName()).addAttribute(TESTS_ATTRIBUTE_LABEL, String.valueOf(suite.getTests())).addAttribute(FAILURE_ATTRIBUTE_LABEL, String.valueOf(suite.getFailures())).addAttribute(ERROR_ATTRIBUTE_LABEL, String.valueOf(suite.getErrors())).addAttribute(IGNORE_ATTRIBUTE_LABEL, String.valueOf(suite.getSkips())).addAttribute("time", String.valueOf(suite.getTime()));
    }

    public void addTest(Document document) {
        Element element = document.getRootElement();
        String string = element.attributeValue("name");
        if (!this.recordedRuns.contains(string) && !string.equals("null")) {
            this.recordedRuns.add(string);
            this.suite.addTest();
        }
        long l = Long.parseLong(element.attributeValue("time"));
        this.suite.addTime(l);
        element.attribute("time").setText(this.formatTime(l));
        if (element.attributeValue("name").equals("null")) {
            element.attribute("name").setText(element.attributeValue(CLASSNAME_ATTRIBUTE));
        }
        this.document.getRootElement().add(element);
        this.checkForStatus(document);
        element.remove(element.attribute(STATUS_ATTRIBUTE));
    }

    private String formatTime(long l) {
        return String.format("%.3f", new Double((double)l / 1000.0));
    }

    private void checkForStatus(Document document) {
        Element element = document.getRootElement();
        String string = element.attributeValue("name");
        String string2 = element.attributeValue(STATUS_ATTRIBUTE);
        String string3 = null;
        if (string2.equals(FAILURE)) {
            string3 = FAILED_TEST;
            this.suite.addFailure();
        } else if (string2.equals(ERROR)) {
            string3 = ERRORED_TEST;
            this.suite.addError();
        } else if (string2.equals(IGNORE)) {
            string3 = IGNORED_TEST;
            this.suite.addSkip();
        }
        if (string3 != null) {
            String string4 = MessageFormat.format(string3, string, this.suite);
            LoggingUtil.log(string4);
        }
    }

    public boolean hasFailures() {
        return this.suite.getErrors() > 0 || this.suite.getFailures() > 0;
    }

    public void save(File file) throws BuildException {
        try {
            File file2 = new File(file, FILENAME_PREFIX + this.suite + FILENAME_EXTENSION);
            Element element = this.document.getRootElement();
            element.addAttribute(FAILURE_ATTRIBUTE_LABEL, String.valueOf(this.suite.getFailures()));
            element.addAttribute(ERROR_ATTRIBUTE_LABEL, String.valueOf(this.suite.getErrors()));
            element.addAttribute(TESTS_ATTRIBUTE_LABEL, String.valueOf(this.suite.getTests()));
            element.addAttribute(IGNORE_ATTRIBUTE_LABEL, String.valueOf(this.suite.getSkips()));
            element.addAttribute("time", String.valueOf(this.formatTime(this.suite.getTime())));
            element.addAttribute(HOSTNAME_ATTRIBUTE_LABEL, this.getHostname());
            String string = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss");
            element.addAttribute(TIMESTAMP_ATTRIBUTE_LABEL, string);
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            XMLWriter xMLWriter = new XMLWriter(new FileOutputStream(file2), outputFormat);
            xMLWriter.write(this.document);
            xMLWriter.close();
        }
        catch (Exception exception) {
            throw new BuildException(ERROR_SAVING_REPORT, (Throwable)exception);
        }
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    public String getSummary() {
        String string = "";
        try {
            string = MessageFormat.format(TEST_INFO, new String(this.suite.getName()), new Integer(this.suite.getTests()), new Integer(this.suite.getFailures()), new Integer(this.suite.getErrors()), new Integer(this.suite.getSkips()), this.formatTime(this.suite.getTime()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

