/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class PendingSplitsCheckpoint<SplitT extends FileSourceSplit> {
    private final Collection<SplitT> splits;
    private final Collection<Path> alreadyProcessedPaths;
    @Nullable
    byte[] serializedFormCache;

    protected PendingSplitsCheckpoint(Collection<SplitT> splits, Collection<Path> alreadyProcessedPaths) {
        this.splits = Collections.unmodifiableCollection(splits);
        this.alreadyProcessedPaths = Collections.unmodifiableCollection(alreadyProcessedPaths);
    }

    public Collection<SplitT> getSplits() {
        return this.splits;
    }

    public Collection<Path> getAlreadyProcessedPaths() {
        return this.alreadyProcessedPaths;
    }

    public String toString() {
        return "PendingSplitsCheckpoint:\n\t\t Pending Splits: " + this.splits + '\n' + "\t\t Processed Paths: " + this.alreadyProcessedPaths + '\n';
    }

    public static <T extends FileSourceSplit> PendingSplitsCheckpoint<T> fromCollectionSnapshot(Collection<T> splits) {
        Preconditions.checkNotNull(splits);
        ArrayList<T> copy = new ArrayList<T>(splits);
        return new PendingSplitsCheckpoint<T>(copy, Collections.emptySet());
    }

    public static <T extends FileSourceSplit> PendingSplitsCheckpoint<T> fromCollectionSnapshot(Collection<T> splits, Collection<Path> alreadyProcessedPaths) {
        Preconditions.checkNotNull(splits);
        ArrayList<T> splitsCopy = new ArrayList<T>(splits);
        ArrayList<Path> pathsCopy = new ArrayList<Path>(alreadyProcessedPaths);
        return new PendingSplitsCheckpoint<T>(splitsCopy, pathsCopy);
    }

    static <T extends FileSourceSplit> PendingSplitsCheckpoint<T> reusingCollection(Collection<T> splits, Collection<Path> alreadyProcessedPaths) {
        return new PendingSplitsCheckpoint<T>(splits, alreadyProcessedPaths);
    }
}

