/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.columnar.vector.heap;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.columnar.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableFloatVector;

@Internal
public class HeapFloatVector
extends AbstractHeapVector
implements WritableFloatVector {
    private static final long serialVersionUID = 8928878923550041110L;
    public float[] vector;

    public HeapFloatVector(int len) {
        super(len);
        this.vector = new float[len];
    }

    @Override
    public float getFloat(int i) {
        if (this.dictionary == null) {
            return this.vector[i];
        }
        return this.dictionary.decodeToFloat(this.dictionaryIds.vector[i]);
    }

    @Override
    public void setFloat(int i, float value) {
        this.vector[i] = value;
    }

    @Override
    public void setFloatsFromBinary(int rowId, int count, byte[] src, int srcIndex) {
        if (rowId + count > this.vector.length || (long)srcIndex + (long)count * 4L > (long)src.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds, row id is %s, count is %s, binary src index is %s, binary length is %s, float array src index is %s, float array length is %s.", rowId, count, srcIndex, src.length, rowId, this.vector.length));
        }
        if (LITTLE_ENDIAN) {
            UNSAFE.copyMemory(src, BYTE_ARRAY_OFFSET + srcIndex, this.vector, (long)FLOAT_ARRAY_OFFSET + (long)rowId * 4L, (long)count * 4L);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(src).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < count; ++i) {
                this.vector[i + rowId] = bb.getFloat(srcIndex + 4 * i);
            }
        }
    }

    @Override
    public void fill(float value) {
        Arrays.fill(this.vector, value);
    }
}

