/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ArrayUnionFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;
    private final SpecializedFunction.ExpressionEvaluator equalityEvaluator;
    private transient MethodHandle equalityHandle;

    public ArrayUnionFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_UNION, context);
        DataType dataType = ((CollectionDataType)context.getCallContext().getOutputDataType().get()).getElementDataType();
        this.elementGetter = ArrayData.createElementGetter((LogicalType)dataType.getLogicalType());
        this.equalityEvaluator = context.createEvaluator((Expression)Expressions.$((String)"element1").isEqual((Object)Expressions.$((String)"element2")), DataTypes.BOOLEAN(), new DataTypes.Field[]{DataTypes.FIELD((String)"element1", (DataType)((DataType)dataType.notNull()).toInternal()), DataTypes.FIELD((String)"element2", (DataType)((DataType)dataType.notNull()).toInternal())});
    }

    public void open(FunctionContext context) throws Exception {
        this.equalityHandle = this.equalityEvaluator.open(context);
    }

    @Nullable
    public ArrayData eval(ArrayData array1, ArrayData array2) {
        try {
            if (array1 == null || array2 == null) {
                return null;
            }
            ArrayList list = new ArrayList();
            Boolean[] alreadyIncludeNull = new Boolean[]{Boolean.FALSE};
            this.distinct(array1, this.elementGetter, this.equalityHandle, alreadyIncludeNull, list);
            this.distinct(array2, this.elementGetter, this.equalityHandle, alreadyIncludeNull, list);
            return new GenericArrayData(list.toArray());
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    List distinct(ArrayData array, ArrayData.ElementGetter elementGetter, MethodHandle equalityHandle, Boolean[] alreadyIncludeNull, List list) throws Throwable {
        for (int i = 0; i < array.size(); ++i) {
            Object element = elementGetter.getElementOrNull(array, i);
            boolean found = false;
            if (element == null) {
                if (alreadyIncludeNull[0].booleanValue()) {
                    found = true;
                } else {
                    alreadyIncludeNull[0] = Boolean.TRUE;
                }
            } else {
                for (int j = 0; !found && j < list.size(); ++j) {
                    Object va = list.get(j);
                    if (va == null || !equalityHandle.invoke(element, va)) continue;
                    found = true;
                }
            }
            if (found) continue;
            list.add(element);
        }
        return list;
    }

    public void close() throws Exception {
        this.equalityEvaluator.close();
    }
}

