/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.TimestampData;

@Internal
public class TimestampDataSerializer
extends TypeSerializer<TimestampData> {
    private static final long serialVersionUID = 1L;
    private final int precision;

    public TimestampDataSerializer(int precision) {
        this.precision = precision;
    }

    public boolean isImmutableType() {
        return true;
    }

    public TypeSerializer<TimestampData> duplicate() {
        return new TimestampDataSerializer(this.precision);
    }

    public TimestampData createInstance() {
        return TimestampData.fromEpochMillis((long)0L);
    }

    public TimestampData copy(TimestampData from) {
        return from;
    }

    public TimestampData copy(TimestampData from, TimestampData reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return TimestampData.isCompact((int)this.precision) ? 8 : 12;
    }

    public void serialize(TimestampData record, DataOutputView target) throws IOException {
        if (TimestampData.isCompact((int)this.precision)) {
            assert (record.getNanoOfMillisecond() == 0);
            target.writeLong(record.getMillisecond());
        } else {
            target.writeLong(record.getMillisecond());
            target.writeInt(record.getNanoOfMillisecond());
        }
    }

    public TimestampData deserialize(DataInputView source) throws IOException {
        if (TimestampData.isCompact((int)this.precision)) {
            long val = source.readLong();
            return TimestampData.fromEpochMillis((long)val);
        }
        long longVal = source.readLong();
        int intVal = source.readInt();
        return TimestampData.fromEpochMillis((long)longVal, (int)intVal);
    }

    public TimestampData deserialize(TimestampData reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        if (TimestampData.isCompact((int)this.precision)) {
            target.writeLong(source.readLong());
        } else {
            target.writeLong(source.readLong());
            target.writeInt(source.readInt());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TimestampDataSerializer that = (TimestampDataSerializer)((Object)obj);
        return this.precision == that.precision;
    }

    public int hashCode() {
        return this.precision;
    }

    public TypeSerializerSnapshot<TimestampData> snapshotConfiguration() {
        return new TimestampDataSerializerSnapshot(this.precision);
    }

    public static final class TimestampDataSerializerSnapshot
    implements TypeSerializerSnapshot<TimestampData> {
        private static final int CURRENT_VERSION = 1;
        private int precision;

        public TimestampDataSerializerSnapshot() {
        }

        TimestampDataSerializerSnapshot(int precision) {
            this.precision = precision;
        }

        public int getCurrentVersion() {
            return 1;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.precision);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.precision = in.readInt();
        }

        public TypeSerializer<TimestampData> restoreSerializer() {
            return new TimestampDataSerializer(this.precision);
        }

        public TypeSerializerSchemaCompatibility<TimestampData> resolveSchemaCompatibility(TypeSerializerSnapshot<TimestampData> oldSerializerSnapshot) {
            if (!(oldSerializerSnapshot instanceof TimestampDataSerializerSnapshot)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            TimestampDataSerializerSnapshot timestampDataSerializerSnapshot = (TimestampDataSerializerSnapshot)oldSerializerSnapshot;
            if (this.precision != timestampDataSerializerSnapshot.precision) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

