/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.operations.AbstractShowOperation;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.utils.ShowLikeOperator;

@Internal
public class ShowTablesOperation
extends AbstractShowOperation {
    @Nullable
    private final String databaseName;

    public ShowTablesOperation(@Nullable String catalogName, @Nullable String databaseName, @Nullable String preposition, @Nullable ShowLikeOperator likeOp) {
        super(catalogName, preposition, likeOp);
        this.databaseName = databaseName;
    }

    public ShowTablesOperation(@Nullable String catalogName, @Nullable String databaseName, @Nullable ShowLikeOperator likeOp) {
        this(catalogName, databaseName, null, likeOp);
    }

    public ShowTablesOperation(@Nullable String catalogName, @Nullable String databaseName) {
        this(catalogName, databaseName, null);
    }

    protected Set<String> retrieveDataForTableResult(ExecutableOperation.Context ctx) {
        CatalogManager catalogManager = ctx.getCatalogManager();
        String qualifiedCatalogName = catalogManager.qualifyCatalog(this.catalogName);
        String qualifiedDatabaseName = catalogManager.qualifyDatabase(this.databaseName);
        if (this.preposition == null) {
            return catalogManager.listTables();
        }
        Catalog catalog = catalogManager.getCatalogOrThrowException(qualifiedCatalogName);
        if (catalog.databaseExists(qualifiedDatabaseName)) {
            return catalogManager.listTables(qualifiedCatalogName, qualifiedDatabaseName);
        }
        throw new ValidationException(String.format("Database '%s'.'%s' doesn't exist.", qualifiedCatalogName, qualifiedDatabaseName));
    }

    @Override
    protected String getOperationName() {
        return "SHOW TABLES";
    }

    @Override
    protected String getColumnName() {
        return "table name";
    }

    @Override
    public String getPrepositionSummaryString() {
        if (this.databaseName == null) {
            return super.getPrepositionSummaryString();
        }
        return super.getPrepositionSummaryString() + "." + this.databaseName;
    }
}

