/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.util;

import static org.junit.Assert.assertEquals;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

import org.apache.hbase.thirdparty.com.google.gson.Gson;

@Category({ MiscTests.class, SmallTests.class })
public class TestGsonUtil {

  @ClassRule
  public static final HBaseClassTestRule CLASS_RULE =
    HBaseClassTestRule.forClass(TestGsonUtil.class);

  private static final Gson GSON = GsonUtil.createGson().create();
  private static final Gson DHE_GSON = GsonUtil.createGsonWithDisableHtmlEscaping().create();

  // This triggers error-prone: "[UnicodeEscape] Using unicode escape sequences for printable ASCII
  // characters is obfuscated, and potentially dangerous."
  // The UnicodeEscape warning cannot be disabled. Consider rewriting this test.

  @Test
  public void testDisableHtmlEscaping() {
    // enable html escaping, turn '=' into '\u003d'
    assertEquals("\"\\u003d\\u003d\\u003d\"", GSON.toJson("==="));

    // disable html escaping
    assertEquals("\"===\"", DHE_GSON.toJson("==="));
  }
}
