/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.http.hbck.resource;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.hbase.HbckEmptyRegionInfo;
import org.apache.hadoop.hbase.HbckInconsistentRegions;
import org.apache.hadoop.hbase.HbckOrphanRegionsOnFS;
import org.apache.hadoop.hbase.HbckOrphanRegionsOnRS;
import org.apache.hadoop.hbase.HbckOverlapRegions;
import org.apache.hadoop.hbase.HbckRegionDetails;
import org.apache.hadoop.hbase.HbckRegionHoles;
import org.apache.hadoop.hbase.HbckServerName;
import org.apache.hadoop.hbase.HbckUnknownServers;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.hbck.HbckReport;
import org.apache.hadoop.hbase.master.http.hbck.model.HbckMetrics;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitorReport;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.yetus.audience.InterfaceAudience;

@Path(value="hbck-metrics")
@Produces(value={"application/json"})
@InterfaceAudience.Private
public class HbckMetricsResource {
    private final HbckReport hbckReport;
    private final CatalogJanitorReport catalogJanitorReport;

    @Inject
    public HbckMetricsResource(MasterServices master) {
        this.hbckReport = master.getHbckChore().getLastReport();
        this.catalogJanitorReport = master.getCatalogJanitor().getLastReport();
    }

    @GET
    public HbckMetrics getBaseHbckMetrics() {
        return new HbckMetrics(this.hbckReport.getCheckingStartTimestamp().toEpochMilli(), this.hbckReport.getCheckingEndTimestamp().toEpochMilli(), this.getOrphanRegionsOnFS(), this.getOrphanRegionsOnRS(), this.getInconsistentRegions(), this.getRegionChainHoles(), this.getRegionChainOverlap(), this.getUnknownServers(), this.getEmptyRegionInfo());
    }

    @GET
    @Path(value="/orphan-regions-on-fs")
    public List<HbckOrphanRegionsOnFS> getOrphanRegionsOnFS() {
        return this.hbckReport.getOrphanRegionsOnFS().entrySet().stream().map(obj1 -> new HbckOrphanRegionsOnFS((String)obj1.getKey(), ((org.apache.hadoop.fs.Path)obj1.getValue()).toString())).collect(Collectors.toList());
    }

    @GET
    @Path(value="/orphan-regions-on-rs")
    public List<HbckOrphanRegionsOnRS> getOrphanRegionsOnRS() {
        return this.hbckReport.getOrphanRegionsOnRS().entrySet().stream().map(obj1 -> new HbckOrphanRegionsOnRS((String)obj1.getKey(), this.parseServerName((ServerName)obj1.getValue()))).collect(Collectors.toList());
    }

    @GET
    @Path(value="/inconsistent-regions")
    public List<HbckInconsistentRegions> getInconsistentRegions() {
        return this.hbckReport.getInconsistentRegions().entrySet().stream().map(obj1 -> new HbckInconsistentRegions((String)obj1.getKey(), this.parseServerName((ServerName)((Pair)obj1.getValue()).getFirst()), ((List)((Pair)obj1.getValue()).getSecond()).stream().map(this::parseServerName).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    @GET
    @Path(value="/region-holes")
    public List<HbckRegionHoles> getRegionChainHoles() {
        return this.catalogJanitorReport.getHoles().stream().map(obj1 -> new HbckRegionHoles(this.parseRegionInfo((RegionInfo)obj1.getFirst()), this.parseRegionInfo((RegionInfo)obj1.getSecond()))).collect(Collectors.toList());
    }

    @GET
    @Path(value="/region-overlaps")
    public List<HbckOverlapRegions> getRegionChainOverlap() {
        return this.catalogJanitorReport.getOverlaps().stream().map(obj1 -> new HbckOverlapRegions(this.parseRegionInfo((RegionInfo)obj1.getFirst()), this.parseRegionInfo((RegionInfo)obj1.getSecond()))).collect(Collectors.toList());
    }

    @GET
    @Path(value="/unknown-servers")
    public List<HbckUnknownServers> getUnknownServers() {
        return this.catalogJanitorReport.getUnknownServers().stream().map(obj1 -> new HbckUnknownServers(this.parseRegionInfo((RegionInfo)obj1.getFirst()), this.parseServerName((ServerName)obj1.getSecond()))).collect(Collectors.toList());
    }

    @GET
    @Path(value="/empty-regioninfo")
    public List<HbckEmptyRegionInfo> getEmptyRegionInfo() {
        return this.catalogJanitorReport.getEmptyRegionInfo().stream().map(obj1 -> new HbckEmptyRegionInfo(Bytes.toString((byte[])obj1))).collect(Collectors.toList());
    }

    public HbckRegionDetails parseRegionInfo(RegionInfo regionInfo) {
        return new HbckRegionDetails(regionInfo.getEncodedName(), regionInfo.getTable().getNameAsString(), new String(regionInfo.getStartKey()), new String(regionInfo.getEndKey()));
    }

    public HbckServerName parseServerName(ServerName serverName) {
        return new HbckServerName(serverName.getHostname(), serverName.getPort(), serverName.getStartCode());
    }
}

