/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.logging;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.logging.JulToSlf4jInitializer;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={MiscTests.class, SmallTests.class})
public class TestJul2Slf4j {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestJul2Slf4j.class);
    private String loggerName = this.getClass().getName();
    private Appender mockAppender;

    @Before
    public void setUp() {
        this.mockAppender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)this.mockAppender.getName()).thenReturn((Object)"mockAppender");
        Mockito.when((Object)this.mockAppender.isStarted()).thenReturn((Object)true);
        ((org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)this.loggerName)).addAppender(this.mockAppender);
    }

    @After
    public void tearDown() {
        ((org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)this.loggerName)).removeAppender(this.mockAppender);
    }

    @Test
    public void test() throws IOException {
        final AtomicReference level = new AtomicReference();
        final AtomicReference msg = new AtomicReference();
        ((Appender)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                LogEvent logEvent = (LogEvent)invocation.getArgument(0, LogEvent.class);
                level.set(logEvent.getLevel());
                msg.set(logEvent.getMessage().getFormattedMessage());
                return null;
            }
        }).when((Object)this.mockAppender)).append((LogEvent)ArgumentMatchers.any(LogEvent.class));
        Logger logger = Logger.getLogger(this.loggerName);
        logger.info(this.loggerName);
        ((Appender)Mockito.verify((Object)this.mockAppender, (VerificationMode)Mockito.times((int)1))).append((LogEvent)ArgumentMatchers.any(LogEvent.class));
        Assert.assertEquals((Object)Level.INFO, level.get());
        Assert.assertEquals((Object)this.loggerName, msg.get());
    }

    static {
        System.setProperty("java.util.logging.config.class", JulToSlf4jInitializer.class.getName());
    }
}

