/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestRetryCounter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRetryCounter.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRetryCounter.class);

    @Test
    public void testBasics() throws InterruptedException {
        int maxAttempts = 10;
        RetryCounterFactory factory = new RetryCounterFactory(maxAttempts, 10, 1000);
        RetryCounter retryCounter = factory.create();
        while (retryCounter.shouldRetry()) {
            LOG.info("Attempt={}, backoffTime={}", (Object)retryCounter.getAttemptTimes(), (Object)retryCounter.getBackoffTime());
            retryCounter.sleepUntilNextRetry();
        }
        TestCase.assertTrue((retryCounter.getAttemptTimes() == maxAttempts ? 1 : 0) != 0);
    }
}

