/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.AbstractTestLogRolling;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowRegionServerTests;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={VerySlowRegionServerTests.class, LargeTests.class})
public class TestAsyncLogRolling
extends AbstractTestLogRolling {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncLogRolling.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.fs.async.create.retries", 100);
        conf.set("hbase.wal.provider", "asyncfs");
        AbstractTestLogRolling.setUpBeforeClass();
    }

    @Test
    public void testLogRollOnDatanodeDeath() throws IOException, InterruptedException {
        this.dfsCluster.startDataNodes(TEST_UTIL.getConfiguration(), 3, true, null, null);
        this.tableName = this.getName();
        Table table = this.createTestTable(this.tableName);
        TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
        this.doPut(table, 1);
        this.server = TEST_UTIL.getRSForFirstRegionInTable(table.getName());
        RegionInfo hri = ((HRegion)this.server.getRegions(table.getName()).get(0)).getRegionInfo();
        AsyncFSWAL wal = (AsyncFSWAL)this.server.getWAL(hri);
        int numRolledLogFiles = AsyncFSWALProvider.getNumRolledLogFiles((WAL)wal);
        DatanodeInfo[] dnInfos = wal.getPipeline();
        MiniDFSCluster.DataNodeProperties dnProp = TEST_UTIL.getDFSCluster().stopDataNode(dnInfos[0].getName());
        TEST_UTIL.getDFSCluster().restartDataNode(dnProp);
        this.doPut(table, 2);
        Assert.assertEquals((long)(numRolledLogFiles + 1), (long)AsyncFSWALProvider.getNumRolledLogFiles((WAL)wal));
    }
}

