/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.cache.HttpCacheContext;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.RequestCacheControl;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.cache.ResponseCacheControl;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheControlHeaderGenerator;
import org.apache.hc.client5.http.impl.cache.CacheControlHeaderParser;
import org.apache.hc.client5.http.impl.cache.CacheHit;
import org.apache.hc.client5.http.impl.cache.CacheMatch;
import org.apache.hc.client5.http.impl.cache.CacheSuitability;
import org.apache.hc.client5.http.impl.cache.CachingExecBase;
import org.apache.hc.client5.http.impl.cache.ConditionalRequestBuilder;
import org.apache.hc.client5.http.impl.cache.DefaultAsyncCacheRevalidator;
import org.apache.hc.client5.http.impl.cache.HttpAsyncCache;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.schedule.SchedulingStrategy;
import org.apache.hc.client5.http.validator.ETag;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.impl.BasicEntityDetails;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
class AsyncCachingExec
extends CachingExecBase
implements AsyncExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncCachingExec.class);
    private final HttpAsyncCache responseCache;
    private final DefaultAsyncCacheRevalidator cacheRevalidator;
    private final ConditionalRequestBuilder<HttpRequest> conditionalRequestBuilder;

    AsyncCachingExec(HttpAsyncCache cache, DefaultAsyncCacheRevalidator cacheRevalidator, CacheConfig config) {
        super(config);
        this.responseCache = (HttpAsyncCache)Args.notNull((Object)cache, (String)"Response cache");
        this.cacheRevalidator = cacheRevalidator;
        this.conditionalRequestBuilder = new ConditionalRequestBuilder(request -> BasicRequestBuilder.copy((HttpRequest)request).build());
    }

    AsyncCachingExec(HttpAsyncCache cache, ScheduledExecutorService executorService, SchedulingStrategy schedulingStrategy, CacheConfig config) {
        this(cache, executorService != null ? new DefaultAsyncCacheRevalidator(executorService, schedulingStrategy) : null, config);
    }

    private void triggerResponse(SimpleHttpResponse cacheResponse, AsyncExecChain.Scope scope, AsyncExecCallback asyncExecCallback) {
        scope.execRuntime.releaseEndpoint();
        SimpleBody body = cacheResponse.getBody();
        byte[] content = body != null ? body.getBodyBytes() : null;
        ContentType contentType = body != null ? body.getContentType() : null;
        try {
            AsyncDataConsumer dataConsumer = asyncExecCallback.handleResponse((HttpResponse)cacheResponse, (EntityDetails)(content != null ? new BasicEntityDetails((long)content.length, contentType) : null));
            if (dataConsumer != null) {
                if (content != null) {
                    dataConsumer.consume(ByteBuffer.wrap(content));
                }
                dataConsumer.streamEnd(null);
            }
            asyncExecCallback.completed();
        }
        catch (IOException | HttpException ex) {
            asyncExecCallback.failed((Exception)ex);
        }
    }

    public void execute(final HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        HttpRoute route = scope.route;
        final HttpClientContext context = scope.clientContext;
        URIAuthority authority = request.getAuthority();
        String scheme = request.getScheme();
        HttpHost target = authority != null ? new HttpHost(scheme, (NamedEndpoint)authority) : route.getTargetHost();
        this.doExecute(target, request, entityProducer, scope, chain, new AsyncExecCallback(){

            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                context.setRequest(request);
                context.setResponse(response);
                return asyncExecCallback.handleResponse(response, entityDetails);
            }

            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                asyncExecCallback.handleInformationResponse(response);
            }

            public void completed() {
                asyncExecCallback.completed();
            }

            public void failed(Exception cause) {
                asyncExecCallback.failed(cause);
            }
        });
    }

    public void doExecute(final HttpHost target, final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        RequestCacheControl requestCacheControl;
        final String exchangeId = scope.exchangeId;
        final HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        CancellableDependency operation = scope.cancellableDependency;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} request via cache: {}", (Object)exchangeId, (Object)new RequestLine(request));
        }
        context.setCacheResponseStatus(CacheResponseStatus.CACHE_MISS);
        context.setCacheEntry(null);
        if (this.clientRequestsOurOptions(request)) {
            context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
            this.triggerResponse(SimpleHttpResponse.create((int)501), scope, asyncExecCallback);
            return;
        }
        if (request.containsHeader("Cache-Control")) {
            requestCacheControl = CacheControlHeaderParser.INSTANCE.parse(request);
            context.setRequestCacheControl(requestCacheControl);
        } else {
            requestCacheControl = context.getRequestCacheControlOrDefault();
            CacheControlHeaderGenerator.INSTANCE.generate(requestCacheControl, (HttpMessage)request);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} request cache control: {}", (Object)exchangeId, (Object)requestCacheControl);
        }
        if (this.cacheableRequestPolicy.canBeServedFromCache(requestCacheControl, request)) {
            operation.setDependency(this.responseCache.match(target, request, new FutureCallback<CacheMatch>(){

                public void completed(CacheMatch result) {
                    CacheHit root;
                    CacheHit hit = result != null ? result.hit : null;
                    CacheHit cacheHit = root = result != null ? result.root : null;
                    if (hit == null) {
                        AsyncCachingExec.this.handleCacheMiss(requestCacheControl, root, target, request, entityProducer, scope, chain, asyncExecCallback);
                    } else {
                        ResponseCacheControl responseCacheControl = CacheControlHeaderParser.INSTANCE.parse(hit.entry);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} response cache control: {}", (Object)exchangeId, (Object)responseCacheControl);
                        }
                        context.setResponseCacheControl(responseCacheControl);
                        AsyncCachingExec.this.handleCacheHit(requestCacheControl, responseCacheControl, hit, target, request, entityProducer, scope, chain, asyncExecCallback);
                    }
                }

                public void failed(Exception cause) {
                    asyncExecCallback.failed(cause);
                }

                public void cancelled() {
                    asyncExecCallback.failed((Exception)new InterruptedIOException());
                }
            }));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} request cannot be served from cache", (Object)exchangeId);
            }
            this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
        }
    }

    void chainProceed(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) {
        try {
            chain.proceed(request, entityProducer, scope, asyncExecCallback);
        }
        catch (IOException | HttpException ex) {
            asyncExecCallback.failed((Exception)ex);
        }
    }

    void callBackend(final HttpHost target, final HttpRequest request, AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) {
        String exchangeId = scope.exchangeId;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} calling the backend", (Object)exchangeId);
        }
        final Instant requestDate = this.getCurrentDate();
        final AtomicReference callbackRef = new AtomicReference();
        this.chainProceed(request, entityProducer, scope, chain, new AsyncExecCallback(){

            public AsyncDataConsumer handleResponse(HttpResponse backendResponse, EntityDetails entityDetails) throws HttpException, IOException {
                Instant responseDate = AsyncCachingExec.this.getCurrentDate();
                BackendResponseHandler callback = new BackendResponseHandler(target, request, requestDate, responseDate, scope, asyncExecCallback);
                callbackRef.set(callback);
                return callback.handleResponse(backendResponse, entityDetails);
            }

            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                AsyncExecCallback callback = callbackRef.getAndSet(null);
                if (callback != null) {
                    callback.handleInformationResponse(response);
                } else {
                    asyncExecCallback.handleInformationResponse(response);
                }
            }

            public void completed() {
                AsyncExecCallback callback = callbackRef.getAndSet(null);
                if (callback != null) {
                    callback.completed();
                } else {
                    asyncExecCallback.completed();
                }
            }

            public void failed(Exception cause) {
                AsyncExecCallback callback = callbackRef.getAndSet(null);
                if (callback != null) {
                    callback.failed(cause);
                } else {
                    asyncExecCallback.failed(cause);
                }
            }
        });
    }

    private void handleCacheHit(RequestCacheControl requestCacheControl, ResponseCacheControl responseCacheControl, CacheHit hit, HttpHost target, HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) {
        block39: {
            HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
            String exchangeId = scope.exchangeId;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} cache hit: {}", (Object)exchangeId, (Object)new RequestLine(request));
            }
            context.setCacheResponseStatus(CacheResponseStatus.CACHE_HIT);
            this.cacheHits.getAndIncrement();
            Instant now = this.getCurrentDate();
            CacheSuitability cacheSuitability = this.suitabilityChecker.assessSuitability(requestCacheControl, responseCacheControl, request, hit.entry, now);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} cache suitability: {}", (Object)exchangeId, (Object)cacheSuitability);
            }
            if (cacheSuitability == CacheSuitability.FRESH || cacheSuitability == CacheSuitability.FRESH_ENOUGH) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} cache hit is fresh enough", (Object)exchangeId);
                }
                try {
                    SimpleHttpResponse cacheResponse = this.generateCachedResponse(request, hit.entry, now);
                    context.setCacheEntry(hit.entry);
                    this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                }
                catch (ResourceIOException ex) {
                    if (requestCacheControl.isOnlyIfCached()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} request marked only-if-cached", (Object)exchangeId);
                        }
                        context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
                        SimpleHttpResponse cacheResponse = this.generateGatewayTimeout();
                        this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                        break block39;
                    }
                    context.setCacheResponseStatus(CacheResponseStatus.FAILURE);
                    try {
                        chain.proceed(request, entityProducer, scope, asyncExecCallback);
                    }
                    catch (IOException | HttpException ex2) {
                        asyncExecCallback.failed((Exception)ex2);
                    }
                }
            } else if (requestCacheControl.isOnlyIfCached()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} cache entry not is not fresh and only-if-cached requested", (Object)exchangeId);
                }
                context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
                SimpleHttpResponse cacheResponse = this.generateGatewayTimeout();
                this.triggerResponse(cacheResponse, scope, asyncExecCallback);
            } else if (cacheSuitability == CacheSuitability.MISMATCH) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} cache entry does not match the request; calling backend", (Object)exchangeId);
                }
                this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
            } else if (entityProducer != null && !entityProducer.isRepeatable()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} request is not repeatable; calling backend", (Object)exchangeId);
                }
                this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
            } else if (hit.entry.getStatus() == 304 && !this.suitabilityChecker.isConditional(request)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} non-modified cache entry does not match the non-conditional request; calling backend", (Object)exchangeId);
                }
                this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
            } else if (cacheSuitability == CacheSuitability.REVALIDATION_REQUIRED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} revalidation required; revalidating cache entry", (Object)exchangeId);
                }
                this.revalidateCacheEntryWithoutFallback(responseCacheControl, hit, target, request, entityProducer, scope, chain, asyncExecCallback);
            } else if (cacheSuitability == CacheSuitability.STALE_WHILE_REVALIDATED) {
                if (this.cacheRevalidator != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} serving stale with asynchronous revalidation", (Object)exchangeId);
                    }
                    try {
                        String revalidationExchangeId = ExecSupport.getNextExchangeId();
                        context.setExchangeId(revalidationExchangeId);
                        AsyncExecChain.Scope fork = new AsyncExecChain.Scope(revalidationExchangeId, scope.route, scope.originalRequest, (CancellableDependency)new ComplexFuture(null), (HttpClientContext)HttpCacheContext.create(), scope.execRuntime.fork(), scope.scheduler, scope.execCount);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} starting asynchronous revalidation exchange {}", (Object)exchangeId, (Object)revalidationExchangeId);
                        }
                        this.cacheRevalidator.revalidateCacheEntry(hit.getEntryKey(), asyncExecCallback, c -> this.revalidateCacheEntry(responseCacheControl, hit, target, request, entityProducer, fork, chain, c));
                        context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
                        SimpleHttpResponse cacheResponse = this.responseGenerator.generateResponse(request, hit.entry);
                        context.setCacheEntry(hit.entry);
                        this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                    }
                    catch (IOException ex) {
                        asyncExecCallback.failed((Exception)ex);
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} revalidating stale cache entry (asynchronous revalidation disabled)", (Object)exchangeId);
                    }
                    this.revalidateCacheEntryWithFallback(requestCacheControl, responseCacheControl, hit, target, request, entityProducer, scope, chain, asyncExecCallback);
                }
            } else if (cacheSuitability == CacheSuitability.STALE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} revalidating stale cache entry", (Object)exchangeId);
                }
                this.revalidateCacheEntryWithFallback(requestCacheControl, responseCacheControl, hit, target, request, entityProducer, scope, chain, asyncExecCallback);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} cache entry not usable; calling backend", (Object)exchangeId);
                }
                this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
            }
        }
    }

    void revalidateCacheEntry(ResponseCacheControl responseCacheControl, final CacheHit hit, final HttpHost target, final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) {
        final Instant requestDate = this.getCurrentDate();
        final HttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequest(responseCacheControl, (HttpRequest)BasicRequestBuilder.copy((HttpRequest)request).build(), hit.entry);
        final HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        this.chainProceed(conditionalRequest, entityProducer, scope, chain, new AsyncExecCallback(){
            final AtomicReference<AsyncExecCallback> callbackRef = new AtomicReference();

            void triggerUpdatedCacheEntryResponse(HttpResponse backendResponse, final Instant responseDate) {
                CancellableDependency operation = scope.cancellableDependency;
                operation.setDependency(AsyncCachingExec.this.responseCache.update(hit, target, request, backendResponse, requestDate, responseDate, new FutureCallback<CacheHit>(){

                    public void completed(CacheHit updated) {
                        try {
                            SimpleHttpResponse cacheResponse = AsyncCachingExec.this.generateCachedResponse(request, updated.entry, responseDate);
                            context.setCacheEntry(updated.entry);
                            AsyncCachingExec.this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                        }
                        catch (ResourceIOException ex) {
                            asyncExecCallback.failed((Exception)ex);
                        }
                    }

                    public void failed(Exception ex) {
                        asyncExecCallback.failed(ex);
                    }

                    public void cancelled() {
                        asyncExecCallback.failed((Exception)new InterruptedIOException());
                    }
                }));
            }

            AsyncExecCallback evaluateResponse(HttpResponse backendResponse, Instant responseDate) {
                int statusCode = backendResponse.getCode();
                if (statusCode == 304 || statusCode == 200) {
                    context.setCacheResponseStatus(CacheResponseStatus.VALIDATED);
                    AsyncCachingExec.this.cacheUpdates.getAndIncrement();
                }
                if (statusCode == 304) {
                    return new AsyncExecCallbackWrapper(() -> this.triggerUpdatedCacheEntryResponse(backendResponse, responseDate), arg_0 -> ((AsyncExecCallback)asyncExecCallback).failed(arg_0));
                }
                return new BackendResponseHandler(target, conditionalRequest, requestDate, responseDate, scope, asyncExecCallback);
            }

            public AsyncDataConsumer handleResponse(HttpResponse backendResponse1, EntityDetails entityDetails) throws HttpException, IOException {
                AsyncExecCallback callback1;
                Instant responseDate = AsyncCachingExec.this.getCurrentDate();
                if (HttpCacheEntry.isNewer(hit.entry, (MessageHeaders)backendResponse1)) {
                    BasicHttpRequest unconditional = AsyncCachingExec.this.conditionalRequestBuilder.buildUnconditionalRequest(BasicRequestBuilder.copy((HttpRequest)scope.originalRequest).build());
                    callback1 = new AsyncExecCallbackWrapper(() -> this.lambda$handleResponse$1((HttpRequest)unconditional, entityProducer, scope, chain, asyncExecCallback), arg_0 -> ((AsyncExecCallback)asyncExecCallback).failed(arg_0));
                } else {
                    callback1 = this.evaluateResponse(backendResponse1, responseDate);
                }
                this.callbackRef.set(callback1);
                return callback1.handleResponse(backendResponse1, entityDetails);
            }

            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                AsyncExecCallback callback1 = this.callbackRef.getAndSet(null);
                if (callback1 != null) {
                    callback1.handleInformationResponse(response);
                } else {
                    asyncExecCallback.handleInformationResponse(response);
                }
            }

            public void completed() {
                AsyncExecCallback callback1 = this.callbackRef.getAndSet(null);
                if (callback1 != null) {
                    callback1.completed();
                } else {
                    asyncExecCallback.completed();
                }
            }

            public void failed(Exception cause) {
                AsyncExecCallback callback1 = this.callbackRef.getAndSet(null);
                if (callback1 != null) {
                    callback1.failed(cause);
                } else {
                    asyncExecCallback.failed(cause);
                }
            }

            private /* synthetic */ void lambda$handleResponse$1(HttpRequest unconditional, AsyncEntityProducer entityProducer2, AsyncExecChain.Scope scope2, AsyncExecChain chain2, final AsyncExecCallback asyncExecCallback2) {
                AsyncCachingExec.this.chainProceed(unconditional, entityProducer2, scope2, chain2, new AsyncExecCallback(){

                    public AsyncDataConsumer handleResponse(HttpResponse backendResponse2, EntityDetails entityDetails1) throws HttpException, IOException {
                        Instant responseDate2 = AsyncCachingExec.this.getCurrentDate();
                        AsyncExecCallback callback2 = this.evaluateResponse(backendResponse2, responseDate2);
                        callbackRef.set(callback2);
                        return callback2.handleResponse(backendResponse2, entityDetails1);
                    }

                    public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                        AsyncExecCallback callback2 = callbackRef.getAndSet(null);
                        if (callback2 != null) {
                            callback2.handleInformationResponse(response);
                        } else {
                            asyncExecCallback2.handleInformationResponse(response);
                        }
                    }

                    public void completed() {
                        AsyncExecCallback callback2 = callbackRef.getAndSet(null);
                        if (callback2 != null) {
                            callback2.completed();
                        } else {
                            asyncExecCallback2.completed();
                        }
                    }

                    public void failed(Exception cause) {
                        AsyncExecCallback callback2 = callbackRef.getAndSet(null);
                        if (callback2 != null) {
                            callback2.failed(cause);
                        } else {
                            asyncExecCallback2.failed(cause);
                        }
                    }
                });
            }
        });
    }

    void revalidateCacheEntryWithoutFallback(ResponseCacheControl responseCacheControl, CacheHit hit, HttpHost target, HttpRequest request, AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) {
        final String exchangeId = scope.exchangeId;
        final HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        this.revalidateCacheEntry(responseCacheControl, hit, target, request, entityProducer, scope, chain, new AsyncExecCallback(){
            private final AtomicBoolean committed = new AtomicBoolean();

            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                this.committed.set(true);
                return asyncExecCallback.handleResponse(response, entityDetails);
            }

            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                asyncExecCallback.handleInformationResponse(response);
            }

            public void completed() {
                asyncExecCallback.completed();
            }

            public void failed(Exception cause) {
                if (!this.committed.get() && cause instanceof IOException) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} I/O error while revalidating cache entry", (Object)exchangeId, (Object)cause);
                    }
                    SimpleHttpResponse cacheResponse = AsyncCachingExec.this.generateGatewayTimeout();
                    context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
                    AsyncCachingExec.this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                } else {
                    asyncExecCallback.failed(cause);
                }
            }
        });
    }

    void revalidateCacheEntryWithFallback(final RequestCacheControl requestCacheControl, final ResponseCacheControl responseCacheControl, final CacheHit hit, HttpHost target, final HttpRequest request, AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) {
        final String exchangeId = scope.exchangeId;
        final HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        this.revalidateCacheEntry(responseCacheControl, hit, target, request, entityProducer, scope, chain, new AsyncExecCallback(){
            private final AtomicReference<HttpResponse> committed = new AtomicReference();

            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                int status = response.getCode();
                if (AsyncCachingExec.this.staleIfErrorAppliesTo(status) && AsyncCachingExec.this.suitabilityChecker.isSuitableIfError(requestCacheControl, responseCacheControl, hit.entry, AsyncCachingExec.this.getCurrentDate())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} serving stale response due to {} status and stale-if-error enabled", (Object)exchangeId, (Object)status);
                    }
                    return null;
                }
                this.committed.set(response);
                return asyncExecCallback.handleResponse(response, entityDetails);
            }

            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                asyncExecCallback.handleInformationResponse(response);
            }

            public void completed() {
                HttpResponse response = this.committed.get();
                if (response == null) {
                    try {
                        context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
                        SimpleHttpResponse cacheResponse = AsyncCachingExec.this.responseGenerator.generateResponse(request, hit.entry);
                        context.setCacheEntry(hit.entry);
                        AsyncCachingExec.this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                    }
                    catch (IOException ex) {
                        asyncExecCallback.failed((Exception)ex);
                    }
                } else {
                    asyncExecCallback.completed();
                }
            }

            public void failed(Exception cause) {
                HttpResponse response = this.committed.get();
                if (response == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} I/O error while revalidating cache entry", (Object)exchangeId, (Object)cause);
                    }
                    context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
                    if (cause instanceof IOException && AsyncCachingExec.this.suitabilityChecker.isSuitableIfError(requestCacheControl, responseCacheControl, hit.entry, AsyncCachingExec.this.getCurrentDate())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} serving stale response due to IOException and stale-if-error enabled", (Object)exchangeId);
                        }
                        try {
                            SimpleHttpResponse cacheResponse = AsyncCachingExec.this.responseGenerator.generateResponse(request, hit.entry);
                            context.setCacheEntry(hit.entry);
                            AsyncCachingExec.this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                        }
                        catch (IOException ex) {
                            asyncExecCallback.failed(cause);
                        }
                    } else {
                        SimpleHttpResponse cacheResponse = AsyncCachingExec.this.generateGatewayTimeout();
                        AsyncCachingExec.this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                    }
                } else {
                    asyncExecCallback.failed(cause);
                }
            }
        });
    }

    private void handleCacheMiss(RequestCacheControl requestCacheControl, CacheHit partialMatch, final HttpHost target, final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) {
        String exchangeId = scope.exchangeId;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} cache miss: {}", (Object)exchangeId, (Object)new RequestLine(request));
        }
        this.cacheMisses.getAndIncrement();
        CancellableDependency operation = scope.cancellableDependency;
        if (requestCacheControl.isOnlyIfCached()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} request marked only-if-cached", (Object)exchangeId);
            }
            HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
            context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
            SimpleHttpResponse cacheResponse = this.generateGatewayTimeout();
            this.triggerResponse(cacheResponse, scope, asyncExecCallback);
        }
        if (partialMatch != null && partialMatch.entry.hasVariants() && entityProducer == null) {
            operation.setDependency(this.responseCache.getVariants(partialMatch, new FutureCallback<Collection<CacheHit>>(){

                public void completed(Collection<CacheHit> variants) {
                    if (variants != null && !variants.isEmpty()) {
                        AsyncCachingExec.this.negotiateResponseFromVariants(target, request, entityProducer, scope, chain, asyncExecCallback, variants);
                    } else {
                        AsyncCachingExec.this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
                    }
                }

                public void failed(Exception ex) {
                    asyncExecCallback.failed(ex);
                }

                public void cancelled() {
                    asyncExecCallback.failed((Exception)new InterruptedIOException());
                }
            }));
        } else {
            this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
        }
    }

    void negotiateResponseFromVariants(final HttpHost target, final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback, Collection<CacheHit> variants) {
        final String exchangeId = scope.exchangeId;
        final CancellableDependency operation = scope.cancellableDependency;
        final HashMap<ETag, CacheHit> variantMap = new HashMap<ETag, CacheHit>();
        for (CacheHit variant : variants) {
            ETag eTag = variant.entry.getETag();
            if (eTag == null) continue;
            variantMap.put(eTag, variant);
        }
        HttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequestFromVariants(request, variantMap.keySet());
        final Instant requestDate = this.getCurrentDate();
        this.chainProceed(conditionalRequest, entityProducer, scope, chain, new AsyncExecCallback(){
            final AtomicReference<AsyncExecCallback> callbackRef = new AtomicReference();

            void updateVariantCacheEntry(HttpResponse backendResponse, final Instant responseDate, CacheHit match) {
                final HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
                context.setCacheResponseStatus(CacheResponseStatus.VALIDATED);
                AsyncCachingExec.this.cacheUpdates.getAndIncrement();
                operation.setDependency(AsyncCachingExec.this.responseCache.storeFromNegotiated(match, target, request, backendResponse, requestDate, responseDate, new FutureCallback<CacheHit>(){

                    public void completed(CacheHit hit) {
                        try {
                            SimpleHttpResponse cacheResponse = AsyncCachingExec.this.generateCachedResponse(request, hit.entry, responseDate);
                            context.setCacheEntry(hit.entry);
                            AsyncCachingExec.this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                        }
                        catch (ResourceIOException ex) {
                            asyncExecCallback.failed((Exception)ex);
                        }
                    }

                    public void failed(Exception ex) {
                        asyncExecCallback.failed(ex);
                    }

                    public void cancelled() {
                        asyncExecCallback.failed((Exception)new InterruptedIOException());
                    }
                }));
            }

            public AsyncDataConsumer handleResponse(HttpResponse backendResponse, EntityDetails entityDetails) throws HttpException, IOException {
                Object callback;
                Instant responseDate = AsyncCachingExec.this.getCurrentDate();
                if (backendResponse.getCode() != 304) {
                    callback = new BackendResponseHandler(target, request, requestDate, responseDate, scope, asyncExecCallback);
                } else {
                    ETag resultEtag = ETag.get((MessageHeaders)backendResponse);
                    if (resultEtag == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} 304 response did not contain ETag", (Object)exchangeId);
                        }
                        callback = new AsyncExecCallbackWrapper(() -> AsyncCachingExec.this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback), arg_0 -> ((AsyncExecCallback)asyncExecCallback).failed(arg_0));
                    } else {
                        CacheHit match = (CacheHit)variantMap.get(resultEtag);
                        if (match == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} 304 response did not contain ETag matching one sent in If-None-Match", (Object)exchangeId);
                            }
                            callback = new AsyncExecCallbackWrapper(() -> AsyncCachingExec.this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback), arg_0 -> ((AsyncExecCallback)asyncExecCallback).failed(arg_0));
                        } else if (HttpCacheEntry.isNewer(match.entry, (MessageHeaders)backendResponse)) {
                            BasicHttpRequest unconditional = AsyncCachingExec.this.conditionalRequestBuilder.buildUnconditionalRequest(BasicRequestBuilder.copy((HttpRequest)request).build());
                            callback = new AsyncExecCallbackWrapper(() -> this.lambda$handleResponse$2(target, (HttpRequest)unconditional, entityProducer, scope, chain, asyncExecCallback), arg_0 -> ((AsyncExecCallback)asyncExecCallback).failed(arg_0));
                        } else {
                            callback = new AsyncExecCallbackWrapper(() -> this.updateVariantCacheEntry(backendResponse, responseDate, match), arg_0 -> ((AsyncExecCallback)asyncExecCallback).failed(arg_0));
                        }
                    }
                }
                this.callbackRef.set((AsyncExecCallback)callback);
                return callback.handleResponse(backendResponse, entityDetails);
            }

            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                AsyncExecCallback callback = this.callbackRef.getAndSet(null);
                if (callback != null) {
                    callback.handleInformationResponse(response);
                } else {
                    asyncExecCallback.handleInformationResponse(response);
                }
            }

            public void completed() {
                AsyncExecCallback callback = this.callbackRef.getAndSet(null);
                if (callback != null) {
                    callback.completed();
                } else {
                    asyncExecCallback.completed();
                }
            }

            public void failed(Exception cause) {
                AsyncExecCallback callback = this.callbackRef.getAndSet(null);
                if (callback != null) {
                    callback.failed(cause);
                } else {
                    asyncExecCallback.failed(cause);
                }
            }

            private /* synthetic */ void lambda$handleResponse$2(HttpHost target2, HttpRequest unconditional, AsyncEntityProducer entityProducer2, AsyncExecChain.Scope scope2, AsyncExecChain chain2, AsyncExecCallback asyncExecCallback2) {
                AsyncCachingExec.this.callBackend(target2, unconditional, entityProducer2, scope2, chain2, asyncExecCallback2);
            }
        });
    }

    class BackendResponseHandler
    implements AsyncExecCallback {
        private final HttpHost target;
        private final HttpRequest request;
        private final Instant requestDate;
        private final Instant responseDate;
        private final AsyncExecChain.Scope scope;
        private final AsyncExecCallback asyncExecCallback;
        private final AtomicReference<CachingAsyncDataConsumer> cachingConsumerRef;

        BackendResponseHandler(HttpHost target, HttpRequest request, Instant requestDate, Instant responseDate, AsyncExecChain.Scope scope, AsyncExecCallback asyncExecCallback) {
            this.target = target;
            this.request = request;
            this.requestDate = requestDate;
            this.responseDate = responseDate;
            this.scope = scope;
            this.asyncExecCallback = asyncExecCallback;
            this.cachingConsumerRef = new AtomicReference();
        }

        public AsyncDataConsumer handleResponse(HttpResponse backendResponse, EntityDetails entityDetails) throws HttpException, IOException {
            final String exchangeId = this.scope.exchangeId;
            AsyncCachingExec.this.responseCache.evictInvalidatedEntries(this.target, this.request, backendResponse, new FutureCallback<Boolean>(){

                public void completed(Boolean result) {
                }

                public void failed(Exception ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} unable to flush invalidated entries from cache", (Object)exchangeId, (Object)ex);
                    }
                }

                public void cancelled() {
                }
            });
            if (AsyncCachingExec.this.isResponseTooBig(entityDetails)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} backend response is known to be too big", (Object)exchangeId);
                }
                return this.asyncExecCallback.handleResponse(backendResponse, entityDetails);
            }
            HttpCacheContext context = HttpCacheContext.cast((HttpContext)this.scope.clientContext);
            ResponseCacheControl responseCacheControl = CacheControlHeaderParser.INSTANCE.parse(backendResponse);
            context.setResponseCacheControl(responseCacheControl);
            boolean cacheable = AsyncCachingExec.this.responseCachingPolicy.isResponseCacheable(responseCacheControl, this.request, backendResponse);
            if (cacheable) {
                AsyncCachingExec.this.storeRequestIfModifiedSinceFor304Response(this.request, backendResponse);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} caching backend response", (Object)exchangeId);
                }
                CachingAsyncDataConsumer cachingDataConsumer = new CachingAsyncDataConsumer(exchangeId, this.asyncExecCallback, backendResponse, entityDetails);
                this.cachingConsumerRef.set(cachingDataConsumer);
                return cachingDataConsumer;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} backend response is not cacheable", (Object)exchangeId);
            }
            return this.asyncExecCallback.handleResponse(backendResponse, entityDetails);
        }

        public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
            this.asyncExecCallback.handleInformationResponse(response);
        }

        void triggerNewCacheEntryResponse(HttpResponse backendResponse, Instant responseDate, ByteArrayBuffer buffer) {
            final String exchangeId = this.scope.exchangeId;
            final HttpCacheContext context = HttpCacheContext.cast((HttpContext)this.scope.clientContext);
            CancellableDependency operation = this.scope.cancellableDependency;
            operation.setDependency(AsyncCachingExec.this.responseCache.store(this.target, this.request, backendResponse, buffer, this.requestDate, responseDate, new FutureCallback<CacheHit>(){

                public void completed(CacheHit hit) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} backend response successfully cached", (Object)exchangeId);
                    }
                    try {
                        SimpleHttpResponse cacheResponse = AsyncCachingExec.this.responseGenerator.generateResponse(BackendResponseHandler.this.request, hit.entry);
                        context.setCacheEntry(hit.entry);
                        AsyncCachingExec.this.triggerResponse(cacheResponse, BackendResponseHandler.this.scope, BackendResponseHandler.this.asyncExecCallback);
                    }
                    catch (ResourceIOException ex) {
                        BackendResponseHandler.this.asyncExecCallback.failed((Exception)ex);
                    }
                }

                public void failed(Exception ex) {
                    BackendResponseHandler.this.asyncExecCallback.failed(ex);
                }

                public void cancelled() {
                    BackendResponseHandler.this.asyncExecCallback.failed((Exception)new InterruptedIOException());
                }
            }));
        }

        void triggerCachedResponse(HttpCacheEntry entry) {
            HttpCacheContext context = HttpCacheContext.cast((HttpContext)this.scope.clientContext);
            try {
                SimpleHttpResponse cacheResponse = AsyncCachingExec.this.responseGenerator.generateResponse(this.request, entry);
                context.setCacheEntry(entry);
                AsyncCachingExec.this.triggerResponse(cacheResponse, this.scope, this.asyncExecCallback);
            }
            catch (ResourceIOException ex) {
                this.asyncExecCallback.failed((Exception)ex);
            }
        }

        public void completed() {
            final String exchangeId = this.scope.exchangeId;
            CachingAsyncDataConsumer cachingDataConsumer = this.cachingConsumerRef.getAndSet(null);
            if (cachingDataConsumer == null || cachingDataConsumer.writtenThrough.get()) {
                this.asyncExecCallback.completed();
                return;
            }
            final HttpResponse backendResponse = cachingDataConsumer.backendResponse;
            final ByteArrayBuffer buffer = cachingDataConsumer.bufferRef.getAndSet(null);
            if (backendResponse.getCode() == 304) {
                AsyncCachingExec.this.responseCache.match(this.target, this.request, new FutureCallback<CacheMatch>(){

                    public void completed(CacheMatch result) {
                        CacheHit hit;
                        CacheHit cacheHit = hit = result != null ? result.hit : null;
                        if (hit != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} existing cache entry found, updating cache entry", (Object)exchangeId);
                            }
                            AsyncCachingExec.this.responseCache.update(hit, BackendResponseHandler.this.target, BackendResponseHandler.this.request, backendResponse, BackendResponseHandler.this.requestDate, BackendResponseHandler.this.responseDate, new FutureCallback<CacheHit>(){

                                public void completed(CacheHit updated) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("{} cache entry updated, generating response from updated entry", (Object)exchangeId);
                                    }
                                    BackendResponseHandler.this.triggerCachedResponse(updated.entry);
                                }

                                public void failed(Exception cause) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("{} request failed: {}", (Object)exchangeId, (Object)cause.getMessage());
                                    }
                                    BackendResponseHandler.this.asyncExecCallback.failed(cause);
                                }

                                public void cancelled() {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("{} cache entry updated aborted", (Object)exchangeId);
                                    }
                                    BackendResponseHandler.this.asyncExecCallback.failed((Exception)new InterruptedIOException());
                                }
                            });
                        } else {
                            BackendResponseHandler.this.triggerNewCacheEntryResponse(backendResponse, BackendResponseHandler.this.responseDate, buffer);
                        }
                    }

                    public void failed(Exception cause) {
                        BackendResponseHandler.this.asyncExecCallback.failed(cause);
                    }

                    public void cancelled() {
                        BackendResponseHandler.this.asyncExecCallback.failed((Exception)new InterruptedIOException());
                    }
                });
            } else if (AsyncCachingExec.this.cacheConfig.isFreshnessCheckEnabled()) {
                CancellableDependency operation = this.scope.cancellableDependency;
                operation.setDependency(AsyncCachingExec.this.responseCache.match(this.target, this.request, new FutureCallback<CacheMatch>(){

                    public void completed(CacheMatch result) {
                        CacheHit hit = result != null ? result.hit : null;
                        if (HttpCacheEntry.isNewer(hit != null ? hit.entry : null, (MessageHeaders)backendResponse)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} backend already contains fresher cache entry", (Object)exchangeId);
                            }
                            BackendResponseHandler.this.triggerCachedResponse(hit.entry);
                        } else {
                            BackendResponseHandler.this.triggerNewCacheEntryResponse(backendResponse, BackendResponseHandler.this.responseDate, buffer);
                        }
                    }

                    public void failed(Exception cause) {
                        BackendResponseHandler.this.asyncExecCallback.failed(cause);
                    }

                    public void cancelled() {
                        BackendResponseHandler.this.asyncExecCallback.failed((Exception)new InterruptedIOException());
                    }
                }));
            } else {
                this.triggerNewCacheEntryResponse(backendResponse, this.responseDate, buffer);
            }
        }

        public void failed(Exception cause) {
            this.asyncExecCallback.failed(cause);
        }
    }

    class CachingAsyncDataConsumer
    implements AsyncDataConsumer {
        private final String exchangeId;
        private final AsyncExecCallback fallback;
        private final HttpResponse backendResponse;
        private final EntityDetails entityDetails;
        private final AtomicBoolean writtenThrough;
        private final AtomicReference<ByteArrayBuffer> bufferRef;
        private final AtomicReference<AsyncDataConsumer> dataConsumerRef;

        CachingAsyncDataConsumer(String exchangeId, AsyncExecCallback fallback, HttpResponse backendResponse, EntityDetails entityDetails) {
            this.exchangeId = exchangeId;
            this.fallback = fallback;
            this.backendResponse = backendResponse;
            this.entityDetails = entityDetails;
            this.writtenThrough = new AtomicBoolean(false);
            this.bufferRef = new AtomicReference<ByteArrayBuffer>(entityDetails != null ? new ByteArrayBuffer(1024) : null);
            this.dataConsumerRef = new AtomicReference();
        }

        public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
            AsyncDataConsumer dataConsumer = this.dataConsumerRef.get();
            if (dataConsumer != null) {
                dataConsumer.updateCapacity(capacityChannel);
            } else {
                capacityChannel.update(Integer.MAX_VALUE);
            }
        }

        public final void consume(ByteBuffer src) throws IOException {
            ByteArrayBuffer buffer = this.bufferRef.get();
            if (buffer != null) {
                if (src.hasArray()) {
                    buffer.append(src.array(), src.arrayOffset() + src.position(), src.remaining());
                } else {
                    while (src.hasRemaining()) {
                        buffer.append((int)src.get());
                    }
                }
                if ((long)buffer.length() > AsyncCachingExec.this.cacheConfig.getMaxObjectSize()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} backend response content length exceeds maximum", (Object)this.exchangeId);
                    }
                    this.bufferRef.set(null);
                    try {
                        AsyncDataConsumer dataConsumer = this.fallback.handleResponse(this.backendResponse, this.entityDetails);
                        if (dataConsumer != null) {
                            this.dataConsumerRef.set(dataConsumer);
                            this.writtenThrough.set(true);
                            dataConsumer.consume(ByteBuffer.wrap(buffer.array(), 0, buffer.length()));
                        }
                    }
                    catch (HttpException ex) {
                        this.fallback.failed((Exception)((Object)ex));
                    }
                }
            } else {
                AsyncDataConsumer dataConsumer = this.dataConsumerRef.get();
                if (dataConsumer != null) {
                    dataConsumer.consume(src);
                }
            }
        }

        public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
            AsyncDataConsumer dataConsumer = this.dataConsumerRef.getAndSet(null);
            if (dataConsumer != null) {
                dataConsumer.streamEnd(trailers);
            }
        }

        public void releaseResources() {
            AsyncDataConsumer dataConsumer = this.dataConsumerRef.getAndSet(null);
            if (dataConsumer != null) {
                dataConsumer.releaseResources();
            }
        }
    }

    static class AsyncExecCallbackWrapper
    implements AsyncExecCallback {
        private final Runnable command;
        private final Consumer<Exception> exceptionConsumer;

        AsyncExecCallbackWrapper(Runnable command, Consumer<Exception> exceptionConsumer) {
            this.command = command;
            this.exceptionConsumer = exceptionConsumer;
        }

        public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
            return null;
        }

        public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
        }

        public void completed() {
            this.command.run();
        }

        public void failed(Exception cause) {
            if (this.exceptionConsumer != null) {
                this.exceptionConsumer.accept(cause);
            }
        }
    }
}

