/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.ignite.internal.IgniteVersionUtils;

public class IgniteProperties {
    private static final String FILE_PATH = "ignite.properties";
    private static final Properties PROPS = new Properties();

    public static void readProperties(String path, Properties props, boolean throwExc) {
        try (InputStream is = IgniteVersionUtils.class.getClassLoader().getResourceAsStream(path);){
            if (is == null) {
                if (throwExc) {
                    throw new RuntimeException("Failed to find properties file: " + path);
                }
                return;
            }
            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read properties file: " + path, e);
        }
    }

    public static String get(String key) {
        return PROPS.getProperty(key, "");
    }

    private IgniteProperties() {
    }

    static {
        IgniteProperties.readProperties(FILE_PATH, PROPS, true);
    }
}

