/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRootRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageInitRootInlineRecord
extends MetaPageInitRootRecord {
    private final int inlineSize;

    public MetaPageInitRootInlineRecord(int grpId, long pageId, long rootId, int inlineSize) {
        super(grpId, pageId, rootId);
        this.inlineSize = inlineSize;
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        BPlusMetaIO io = BPlusMetaIO.VERSIONS.forPage(pageAddr);
        io.initRoot(pageAddr, this.rootId, pageMem.realPageSize(this.groupId()));
        io.setInlineSize(pageAddr, this.inlineSize);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_META_PAGE_INIT_ROOT2;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageInitRootInlineRecord.class, this, "super", (Object)super.toString());
    }
}

