/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.memory;

import org.apache.ignite.internal.processors.platform.memory.PlatformAbstractMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryPool;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryUtils;

public class PlatformPooledMemory
extends PlatformAbstractMemory {
    private final PlatformMemoryPool pool;

    public PlatformPooledMemory(PlatformMemoryPool pool, long memPtr) {
        super(memPtr);
        assert (PlatformMemoryUtils.isPooled(memPtr));
        assert (PlatformMemoryUtils.isAcquired(memPtr));
        this.pool = pool;
    }

    @Override
    public void reallocate(int cap) {
        assert (PlatformMemoryUtils.isAcquired(this.memPtr));
        int doubledCap = PlatformMemoryUtils.capacity(this.memPtr) << 1;
        if (doubledCap > cap) {
            cap = doubledCap;
        }
        this.pool.reallocate(this.memPtr, cap);
    }

    @Override
    public void close() {
        assert (PlatformMemoryUtils.isAcquired(this.memPtr));
        this.pool.release(this.memPtr);
    }
}

