/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.tracing.opencensus;

import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import org.apache.ignite.spi.tracing.SpanStatus;
import org.apache.ignite.spi.tracing.SpiSpecificSpan;
import org.apache.ignite.spi.tracing.opencensus.StatusMatchTable;

public class OpenCensusSpanAdapter
implements SpiSpecificSpan {
    private final Span span;
    private volatile boolean ended;

    OpenCensusSpanAdapter(Span span) {
        this.span = span;
    }

    public Span impl() {
        return this.span;
    }

    public OpenCensusSpanAdapter addTag(String tagName, String tagVal) {
        tagVal = tagVal != null ? tagVal : "null";
        this.span.putAttribute(tagName, AttributeValue.stringAttributeValue((String)tagVal));
        return this;
    }

    public OpenCensusSpanAdapter addLog(String logDesc) {
        this.span.addAnnotation(logDesc);
        return this;
    }

    public OpenCensusSpanAdapter setStatus(SpanStatus spanStatus) {
        this.span.setStatus(StatusMatchTable.match(spanStatus));
        return this;
    }

    public OpenCensusSpanAdapter end() {
        this.span.end();
        this.ended = true;
        return this;
    }

    public boolean isEnded() {
        return this.ended;
    }
}

