/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery;

import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.DefaultServiceInstance;
import io.micronaut.health.HealthStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public interface ServiceInstance {
    public static final String GROUP = "group";
    public static final String ZONE = "zone";
    public static final String REGION = "region";

    public String getId();

    public URI getURI();

    default public HealthStatus getHealthStatus() {
        return HealthStatus.UP;
    }

    default public Optional<String> getInstanceId() {
        return Optional.empty();
    }

    default public Optional<String> getZone() {
        return this.getMetadata().get((CharSequence)ZONE, String.class);
    }

    default public Optional<String> getRegion() {
        return this.getMetadata().get((CharSequence)REGION, String.class);
    }

    default public Optional<String> getGroup() {
        return this.getMetadata().get((CharSequence)GROUP, String.class);
    }

    default public ConvertibleValues<String> getMetadata() {
        return ConvertibleValues.empty();
    }

    default public String getHost() {
        return this.getURI().getHost();
    }

    default public boolean isSecure() {
        String scheme = this.getURI().getScheme();
        return scheme != null && scheme.equalsIgnoreCase("https");
    }

    default public int getPort() {
        return this.getURI().getPort();
    }

    default public URI resolve(URI relativeURI) {
        String rawQuery;
        URI thisUri = this.getURI();
        if (StringUtils.isNotEmpty((CharSequence)thisUri.getUserInfo())) {
            try {
                thisUri = new URI(thisUri.getScheme(), null, thisUri.getHost(), thisUri.getPort(), thisUri.getPath(), thisUri.getQuery(), thisUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("ServiceInstance URI is invalid: " + e.getMessage(), e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(rawQuery = thisUri.getRawQuery()))) {
            return thisUri.resolve(relativeURI + "?" + rawQuery);
        }
        return thisUri.resolve(relativeURI);
    }

    public static ServiceInstance of(String id, URL url) {
        try {
            URI uri = url.toURI();
            return ServiceInstance.of(id, uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI argument: " + url);
        }
    }

    public static ServiceInstance of(final String id, final URI uri) {
        return new ServiceInstance(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public URI getURI() {
                return uri;
            }

            @Override
            public ConvertibleValues<String> getMetadata() {
                String userInfo = uri.getUserInfo();
                if (userInfo == null) {
                    return ServiceInstance.super.getMetadata();
                }
                HashMap<String, String> metadata = new HashMap<String, String>(1);
                metadata.put("Authorization-Info", userInfo);
                return ConvertibleValues.of(metadata);
            }
        };
    }

    public static ServiceInstance of(final String id, final String host, final int port) {
        return new ServiceInstance(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public URI getURI() {
                return URI.create("http://" + host + ":" + port);
            }
        };
    }

    public static Builder builder(String id, URI uri) {
        return new DefaultServiceInstance(id, uri);
    }

    public static interface Builder {
        public Builder instanceId(String var1);

        public Builder zone(String var1);

        public Builder region(String var1);

        public Builder group(String var1);

        public Builder status(HealthStatus var1);

        public Builder metadata(Map<String, String> var1);

        public ServiceInstance build();
    }
}

