/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.PairList;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.impl.ModifiableViewTable;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeMappingRule;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.AliasNamespace;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNonNullableAccessors;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Static;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.prepare.IgniteAliasNamespace;
import org.apache.ignite.internal.sql.engine.prepare.IgniteContextException;
import org.apache.ignite.internal.sql.engine.prepare.IgniteSqlValidatorErrorMessages;
import org.apache.ignite.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite.internal.sql.engine.schema.IgniteSystemView;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomType;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomTypeCoercionRules;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IgniteCustomAssignmentsRules;
import org.apache.ignite.internal.sql.engine.util.IgniteResource;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.type.NativeTypeSpec;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlValidator
extends SqlValidatorImpl {
    private static final BigDecimal DEC_INT_MAX = BigDecimal.valueOf(Integer.MAX_VALUE);
    public static final int MAX_LENGTH_OF_ALIASES = 256;
    public static final int DECIMAL_DYNAMIC_PARAM_PRECISION = 28;
    public static final int DECIMAL_DYNAMIC_PARAM_SCALE = 6;
    private static final Set<SqlKind> HUMAN_READABLE_ALIASES_FOR;
    public static final String NUMERIC_FIELD_OVERFLOW_ERROR = "Numeric field overflow";
    private final Int2ObjectMap<DynamicParamState> dynamicParameters;
    private final IdentityHashMap<SqlDynamicParam, SqlDynamicParam> dynamicParamNodes = new IdentityHashMap();
    private final ArrayDeque<CallScope> callScopes = new ArrayDeque();

    public IgniteSqlValidator(SqlOperatorTable opTab, CalciteCatalogReader catalogReader, IgniteTypeFactory typeFactory, SqlValidator.Config config, Int2ObjectMap<Object> parameters) {
        super(opTab, (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)typeFactory, config);
        this.dynamicParameters = new Int2ObjectArrayMap(parameters.size());
        for (Map.Entry param : parameters.int2ObjectEntrySet()) {
            Object value = param.getValue();
            this.dynamicParameters.put(((Integer)param.getKey()).intValue(), (Object)new DynamicParamState(value));
        }
    }

    public SqlNode validate(SqlNode topNode) {
        SqlNode result;
        if (topNode instanceof SqlExplain) {
            SqlExplain explainNode = (SqlExplain)topNode;
            SqlNode topNodeToValidate = explainNode.getExplicandum();
            SqlNode validatedNode = super.validate(topNodeToValidate);
            explainNode.setOperand(0, validatedNode);
            result = explainNode;
        } else {
            result = super.validate(topNode);
        }
        this.validateInferredDynamicParameters();
        return result;
    }

    protected void registerNamespace(@Nullable SqlValidatorScope usingScope, @Nullable String alias, SqlValidatorNamespace ns, boolean forceNullable) {
        if (ns instanceof AliasNamespace) {
            SqlNode call = ns.getNode();
            SqlNode enclosingNode = ns.getEnclosingNode();
            assert (call instanceof SqlCall);
            assert (enclosingNode != null);
            ns = new IgniteAliasNamespace((SqlValidatorImpl)ns.getValidator(), (SqlCall)call, enclosingNode);
        }
        super.registerNamespace(usingScope, alias, ns, forceNullable);
    }

    public void validateInsert(SqlInsert insert) {
        SqlValidatorTable table = this.table(this.validatedNamespace((SqlNode)insert, this.unknownType));
        IgniteTable igniteTable = this.getIgniteTableForModification((SqlIdentifier)insert.getTargetTable(), table);
        if (insert.getTargetColumnList() == null) {
            insert.setOperand(3, (SqlNode)this.inferColumnList(igniteTable));
        }
        super.validateInsert(insert);
    }

    public void validateUpdate(SqlUpdate call) {
        this.validateUpdateFields(call);
        super.validateUpdate(call);
        SqlSelect select = call.getSourceSelect();
        assert (select != null) : "Update: SourceSelect has not been set";
        IgniteSqlValidator.syncSelectList(select, call);
    }

    public void validateWithItem(SqlWithItem withItem) {
        if (withItem.recursive.booleanValue()) {
            throw this.newValidationError((SqlNode)withItem.recursive, IgniteResource.INSTANCE.recursiveQueryIsNotSupported());
        }
        super.validateWithItem(withItem);
    }

    public void validateMerge(SqlMerge call) {
        super.validateMerge(call);
        SqlSelect select = call.getSourceSelect();
        SqlUpdate update = call.getUpdateCall();
        if (update != null) {
            assert (select != null) : "Merge: SourceSelect has not been set";
            IgniteSqlValidator.syncSelectList(select, update);
        }
    }

    public CalciteContextException newValidationError(SqlNode node, Resources.ExInst<SqlValidatorException> e) {
        CalciteContextException newEx;
        CalciteContextException ex = super.newValidationError(node, e);
        String newMessage = IgniteSqlValidatorErrorMessages.resolveErrorMessage(ex.getMessage());
        if (newMessage != null) {
            newEx = new IgniteContextException(newMessage, ex.getCause());
            newEx.setPosition(ex.getPosLine(), ex.getPosColumn(), ex.getEndPosLine(), ex.getEndPosColumn());
            newEx.setOriginalStatement(ex.getOriginalStatement());
        } else {
            newEx = ex;
        }
        return newEx;
    }

    protected void checkTypeAssignment(@Nullable SqlValidatorScope sourceScope, SqlValidatorTable table, RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
        boolean coerced;
        boolean isUpdateModifiableViewTable = false;
        if (query instanceof SqlUpdate) {
            SqlNodeList targetColumnList = Objects.requireNonNull(((SqlUpdate)query).getTargetColumnList());
            int targetColumnCount = targetColumnList.size();
            targetRowType = SqlTypeUtil.extractLastNFields((RelDataTypeFactory)this.typeFactory, (RelDataType)targetRowType, (int)targetColumnCount);
            sourceRowType = SqlTypeUtil.extractLastNFields((RelDataTypeFactory)this.typeFactory, (RelDataType)sourceRowType, (int)targetColumnCount);
            boolean bl = isUpdateModifiableViewTable = table.unwrap(ModifiableViewTable.class) != null;
        }
        if (SqlTypeUtil.equalAsStructSansNullability((RelDataTypeFactory)this.typeFactory, (RelDataType)sourceRowType, (RelDataType)targetRowType, null)) {
            return;
        }
        if (this.config().typeCoercionEnabled() && !isUpdateModifiableViewTable && (coerced = this.getTypeCoercion().querySourceCoercion(sourceScope, sourceRowType, targetRowType, query))) {
            return;
        }
        List sourceFields = sourceRowType.getFieldList();
        List targetFields = targetRowType.getFieldList();
        int sourceCount = sourceFields.size();
        for (int i = 0; i < sourceCount; ++i) {
            String targetTypeString;
            String sourceTypeString;
            RelDataType sourceType = ((RelDataTypeField)sourceFields.get(i)).getType();
            RelDataType targetType = ((RelDataTypeField)targetFields.get(i)).getType();
            boolean canAssign = SqlTypeUtil.canAssignFrom((RelDataType)targetType, (RelDataType)sourceType);
            if (canAssign && (targetType instanceof IgniteCustomType || sourceType instanceof IgniteCustomType)) {
                canAssign = SqlTypeUtil.equalSansNullability((RelDataTypeFactory)this.typeFactory, (RelDataType)targetType, (RelDataType)sourceType);
            }
            if (canAssign) continue;
            if (SqlTypeUtil.areCharacterSetsMismatched((RelDataType)sourceType, (RelDataType)targetType)) {
                sourceTypeString = sourceType.getFullTypeString();
                targetTypeString = targetType.getFullTypeString();
            } else {
                sourceTypeString = sourceType.toString();
                targetTypeString = targetType.toString();
            }
            SqlNode node = IgniteSqlValidator.getNthExpr(query, i, sourceCount);
            throw this.newValidationError(node, (Resources.ExInst<SqlValidatorException>)Static.RESOURCE.typeNotAssignable(((RelDataTypeField)targetFields.get(i)).getName(), targetTypeString, ((RelDataTypeField)sourceFields.get(i)).getName(), sourceTypeString));
        }
    }

    private static SqlNode getNthExpr(SqlNode query, int ordinal, int sourceCount) {
        if (query instanceof SqlInsert) {
            SqlInsert insert = (SqlInsert)query;
            if (insert.getTargetColumnList() != null) {
                return insert.getTargetColumnList().get(ordinal);
            }
            return IgniteSqlValidator.getNthExpr(insert.getSource(), ordinal, sourceCount);
        }
        if (query instanceof SqlUpdate) {
            SqlUpdate update = (SqlUpdate)query;
            if (update.getSourceExpressionList() != null) {
                return update.getSourceExpressionList().get(ordinal);
            }
            return IgniteSqlValidator.getNthExpr((SqlNode)SqlNonNullableAccessors.getSourceSelect((SqlUpdate)update), ordinal, sourceCount);
        }
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            SqlNodeList selectList = SqlNonNullableAccessors.getSelectList((SqlSelect)select);
            if (selectList.size() == sourceCount) {
                return selectList.get(ordinal);
            }
            return query;
        }
        return query;
    }

    private IgniteTable getTableForModification(SqlIdentifier identifier) {
        SqlValidatorTable table = this.getCatalogReader().getTable((List)identifier.names);
        if (table == null) {
            throw this.newValidationError((SqlNode)identifier, (Resources.ExInst<SqlValidatorException>)Static.RESOURCE.objectNotFound(identifier.toString()));
        }
        return this.getIgniteTableForModification(identifier, table);
    }

    private IgniteTable getIgniteTableForModification(SqlIdentifier identifier, SqlValidatorTable table) {
        IgniteDataSource dataSource = (IgniteDataSource)table.unwrap(IgniteDataSource.class);
        assert (dataSource != null);
        if (dataSource instanceof IgniteSystemView) {
            throw this.newValidationError((SqlNode)identifier, IgniteResource.INSTANCE.systemViewIsNotModifiable(identifier.toString()));
        }
        return (IgniteTable)dataSource;
    }

    private void doCheckTypeAssignment(@Nullable SqlValidatorScope sourceScope, SqlValidatorTable table, RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
        boolean coerced;
        boolean isUpdateModifiableViewTable = false;
        if (query instanceof SqlUpdate) {
            SqlNodeList targetColumnList = Objects.requireNonNull(((SqlUpdate)query).getTargetColumnList());
            int targetColumnCount = targetColumnList.size();
            targetRowType = SqlTypeUtil.extractLastNFields((RelDataTypeFactory)this.typeFactory, (RelDataType)targetRowType, (int)targetColumnCount);
            sourceRowType = SqlTypeUtil.extractLastNFields((RelDataTypeFactory)this.typeFactory, (RelDataType)sourceRowType, (int)targetColumnCount);
            boolean bl = isUpdateModifiableViewTable = table.unwrap(ModifiableViewTable.class) != null;
        }
        if (SqlTypeUtil.equalAsStructSansNullability((RelDataTypeFactory)this.typeFactory, (RelDataType)sourceRowType, (RelDataType)targetRowType, null)) {
            return;
        }
        if (this.config().typeCoercionEnabled() && !isUpdateModifiableViewTable && (coerced = this.getTypeCoercion().querySourceCoercion(sourceScope, sourceRowType, targetRowType, query))) {
            return;
        }
        List sourceFields = sourceRowType.getFieldList();
        List targetFields = targetRowType.getFieldList();
        int sourceCount = sourceFields.size();
        for (int i = 0; i < sourceCount; ++i) {
            String targetTypeString;
            String sourceTypeString;
            RelDataType sourceType = ((RelDataTypeField)sourceFields.get(i)).getType();
            RelDataType targetType = ((RelDataTypeField)targetFields.get(i)).getType();
            if (SqlTypeUtil.canAssignFrom((RelDataType)targetType, (RelDataType)sourceType) || sourceType == this.unknownType) continue;
            if (SqlTypeUtil.areCharacterSetsMismatched((RelDataType)sourceType, (RelDataType)targetType)) {
                sourceTypeString = sourceType.getFullTypeString();
                targetTypeString = targetType.getFullTypeString();
            } else {
                sourceTypeString = sourceType.toString();
                targetTypeString = targetType.toString();
            }
            throw this.newValidationError(query, (Resources.ExInst<SqlValidatorException>)Static.RESOURCE.typeNotAssignable(((RelDataTypeField)targetFields.get(i)).getName(), targetTypeString, ((RelDataTypeField)sourceFields.get(i)).getName(), sourceTypeString));
        }
    }

    private static void syncSelectList(SqlSelect select, SqlUpdate update) {
        SqlNodeList sourceExpressionList = update.getSourceExpressionList();
        SqlNodeList selectList = select.getSelectList();
        int sourceExprListSize = sourceExpressionList.size();
        int startPosition = selectList.size() - sourceExprListSize;
        for (int i = 0; i < sourceExprListSize; ++i) {
            SqlNode replacement = sourceExpressionList.get(i);
            int position = startPosition + i;
            if (!(replacement instanceof SqlBasicCall)) continue;
            selectList.set(position, replacement);
        }
    }

    public void validateLiteral(SqlLiteral literal) {
        if (literal.getTypeName() != SqlTypeName.DECIMAL) {
            super.validateLiteral(literal);
        }
    }

    protected RelDataType createTargetRowType(SqlValidatorTable table, SqlNodeList targetColumnList, boolean append, SqlIdentifier targetTableAlias) {
        RelDataType baseRowType = ((IgniteTable)table.unwrap(IgniteTable.class)).rowTypeForInsert((IgniteTypeFactory)this.typeFactory);
        if (targetColumnList == null) {
            return baseRowType;
        }
        List targetFields = baseRowType.getFieldList();
        PairList fields = PairList.of();
        if (append) {
            for (RelDataTypeField targetField : targetFields) {
                fields.add((Object)SqlUtil.deriveAliasFromOrdinal((int)fields.size()), (Object)targetField.getType());
            }
        }
        HashSet<Integer> assignedFields = new HashSet<Integer>();
        RelOptTable relOptTable = table instanceof RelOptTable ? (RelOptTable)table : null;
        for (SqlNode node : targetColumnList) {
            SqlIdentifier id = (SqlIdentifier)node;
            RelDataTypeField targetField = SqlValidatorUtil.getTargetField((RelDataType)baseRowType, (RelDataTypeFactory)this.typeFactory, (SqlIdentifier)id, (SqlValidatorCatalogReader)this.getCatalogReader(), (RelOptTable)relOptTable);
            if (targetField == null) {
                throw this.newValidationError((SqlNode)id, (Resources.ExInst<SqlValidatorException>)Static.RESOURCE.unknownTargetColumn(id.toString()));
            }
            if (!assignedFields.add(targetField.getIndex())) {
                throw this.newValidationError((SqlNode)id, (Resources.ExInst<SqlValidatorException>)Static.RESOURCE.duplicateTargetColumn(targetField.getName()));
            }
            fields.add((Object)targetField);
        }
        return this.typeFactory.createStructType((List)fields);
    }

    protected SqlSelect createSourceSelectForUpdate(SqlUpdate call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        SqlIdentifier targetTable = (SqlIdentifier)call.getTargetTable();
        IgniteTable igniteTable = this.getTableForModification(targetTable);
        SqlIdentifier alias = call.getAlias() != null ? call.getAlias() : new SqlIdentifier(this.deriveAlias((SqlNode)targetTable, 0), SqlParserPos.ZERO);
        igniteTable.rowTypeForUpdate((IgniteTypeFactory)this.typeFactory).getFieldNames().stream().map(name -> alias.plus(name, SqlParserPos.ZERO)).forEach(arg_0 -> ((SqlNodeList)selectList).add(arg_0));
        int ordinal = 0;
        for (SqlNode exp : call.getSourceExpressionList()) {
            selectList.add(SqlValidatorUtil.addAlias((SqlNode)exp, (String)SqlUtil.deriveAliasFromOrdinal((int)ordinal++)));
        }
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias((SqlNode)sourceTable, (String)call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null, null, null);
    }

    protected void addToSelectList(List<SqlNode> list, Set<String> aliases, List<Map.Entry<String, RelDataType>> fieldList, SqlNode exp, SelectScope scope, boolean includeSystemVars) {
        if (includeSystemVars || exp.getKind() != SqlKind.IDENTIFIER || !IgniteSqlValidator.isSystemFieldName(this.deriveAlias(exp, 0))) {
            super.addToSelectList(list, aliases, fieldList, exp, scope, includeSystemVars);
        }
    }

    protected SqlSelect createSourceSelectForDelete(SqlDelete call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        SqlIdentifier targetTable = (SqlIdentifier)call.getTargetTable();
        IgniteTable igniteTable = this.getTableForModification(targetTable);
        igniteTable.rowTypeForDelete((IgniteTypeFactory)this.typeFactory).getFieldNames().stream().map(name -> new SqlIdentifier(name, SqlParserPos.ZERO)).forEach(arg_0 -> ((SqlNodeList)selectList).add(arg_0));
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias((SqlNode)sourceTable, (String)call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null, null, null);
    }

    protected void validateSelect(SqlSelect select, RelDataType targetRowType) {
        super.validateSelect(select, targetRowType);
        this.checkIntegerLimit(select.getFetch(), "fetch / limit");
        this.checkIntegerLimit(select.getOffset(), "offset");
    }

    private void checkIntegerLimit(@Nullable SqlNode n, String nodeName) {
        if (n == null) {
            return;
        }
        if (n instanceof SqlLiteral) {
            BigDecimal offFetchLimit = ((SqlLiteral)n).bigDecimalValue();
            if (offFetchLimit.compareTo(DEC_INT_MAX) > 0 || offFetchLimit.compareTo(BigDecimal.ZERO) < 0) {
                throw this.newValidationError(n, IgniteResource.INSTANCE.correctIntegerLimit(nodeName));
            }
        } else if (n instanceof SqlDynamicParam) {
            SqlDynamicParam dynamicParam = (SqlDynamicParam)n;
            RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
            if (!this.isUnspecified(dynamicParam)) {
                Object param = this.getDynamicParamValue(dynamicParam);
                if (param instanceof Integer) {
                    if ((Integer)param < 0) {
                        throw this.newValidationError(n, IgniteResource.INSTANCE.correctIntegerLimit(nodeName));
                    }
                } else {
                    String actualType = this.deriveDynamicParamType(dynamicParam).toString();
                    String expectedType = intType.toString();
                    Resources.ExInst<SqlValidatorException> err = IgniteResource.INSTANCE.incorrectDynamicParameterType(expectedType, actualType);
                    throw this.newValidationError(n, err);
                }
            }
            this.setDynamicParamType(dynamicParam, this.typeFactory.createTypeWithNullability(intType, true));
        }
    }

    public String deriveAlias(SqlNode node, int ordinal) {
        if (node.isA(HUMAN_READABLE_ALIASES_FOR)) {
            String alias = node.toSqlString(c -> c.withDialect(CalciteSqlDialect.DEFAULT).withQuoteAllIdentifiers(false).withAlwaysUseParentheses(false).withClauseStartsLine(false)).getSql();
            return alias.substring(0, Math.min(alias.length(), 256));
        }
        return super.deriveAlias(node, ordinal);
    }

    public void validateAggregateParams(SqlCall aggCall, @Nullable SqlNode filter, @Nullable SqlNodeList distinctList, @Nullable SqlNodeList orderList, SqlValidatorScope scope) {
        this.validateAggregateFunction(aggCall, (SqlAggFunction)aggCall.getOperator());
        super.validateAggregateParams(aggCall, filter, null, orderList, scope);
    }

    public RelDataType deriveType(SqlValidatorScope scope, SqlNode expr) {
        RelDataType type = this.getValidatedNodeTypeIfKnown(expr);
        if (type != null) {
            if (expr instanceof SqlDynamicParam) {
                this.setDynamicParamType((SqlDynamicParam)expr, type);
            }
            return type;
        }
        if (expr instanceof SqlDynamicParam) {
            return this.deriveDynamicParamType((SqlDynamicParam)expr);
        }
        this.validateCast(scope, expr);
        RelDataType dataType = super.deriveType(scope, expr);
        this.validateIn(scope, expr);
        SqlKind sqlKind = expr.getKind();
        if (sqlKind == SqlKind.JSON_VALUE_EXPRESSION) {
            String name = SqlStdOperatorTable.JSON_VALUE_EXPRESSION.getName();
            throw this.newValidationError(expr, IgniteResource.INSTANCE.unsupportedExpression(name));
        }
        if (!SqlKind.BINARY_COMPARISON.contains(sqlKind)) {
            return dataType;
        }
        SqlCall sqlCall = (SqlCall)expr;
        RelDataType lhs = this.getValidatedNodeType(sqlCall.operand(0));
        RelDataType rhs = this.getValidatedNodeType(sqlCall.operand(1));
        if (lhs instanceof IgniteCustomType || rhs instanceof IgniteCustomType) {
            boolean lhsRhsCompatible = TypeUtils.typeFamiliesAreCompatible(this.typeFactory, lhs, rhs);
            boolean rhsLhsCompatible = TypeUtils.typeFamiliesAreCompatible(this.typeFactory, rhs, lhs);
            if (!lhsRhsCompatible && !rhsLhsCompatible) {
                SqlCallBinding callBinding = new SqlCallBinding((SqlValidator)this, scope, (SqlCall)expr);
                throw callBinding.newValidationSignatureError();
            }
        }
        return dataType;
    }

    public RelDataType getParameterRowType(SqlNode sqlQuery) {
        final ArrayList types = new ArrayList();
        IntArraySet alreadyVisited = new IntArraySet(this.dynamicParameters.size());
        sqlQuery.accept((SqlVisitor)new SqlShuttle((IntSet)alreadyVisited, types){
            final /* synthetic */ IntSet val$alreadyVisited;
            final /* synthetic */ List val$types;
            {
                this.val$alreadyVisited = intSet;
                this.val$types = list;
            }

            public SqlNode visit(SqlDynamicParam param) {
                if (this.val$alreadyVisited.add(param.getIndex())) {
                    RelDataType type = IgniteSqlValidator.this.getValidatedNodeType((SqlNode)param);
                    this.val$types.add(type);
                }
                return param;
            }
        });
        return this.typeFactory.createStructType(types, (List)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return "?" + index;
            }

            @Override
            public int size() {
                return types.size();
            }
        });
    }

    private void validateIn(SqlValidatorScope scope, SqlNode expr) {
        RelDataType rightRowType;
        if (expr.getKind() != SqlKind.IN && expr.getKind() != SqlKind.NOT_IN) {
            return;
        }
        SqlCallBinding callBinding = new SqlCallBinding((SqlValidator)this, scope, (SqlCall)expr);
        RelDataType leftHandType = callBinding.getOperandType(0);
        RelDataType rightHandType = callBinding.getOperandType(1);
        RelDataType leftRowType = SqlTypeUtil.promoteToRowType((RelDataTypeFactory)this.typeFactory, (RelDataType)leftHandType, null);
        if (!TypeUtils.typeFamiliesAreCompatible(this.typeFactory, leftRowType, rightRowType = SqlTypeUtil.promoteToRowType((RelDataTypeFactory)this.typeFactory, (RelDataType)rightHandType, null))) {
            throw this.newValidationError(expr, (Resources.ExInst<SqlValidatorException>)Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.IN.getName()));
        }
    }

    private void validateCast(SqlValidatorScope scope, SqlNode expr) {
        boolean nullType;
        if (expr.getKind() != SqlKind.CAST) {
            return;
        }
        SqlBasicCall expr0 = (SqlBasicCall)expr;
        SqlNode castOperand = (SqlNode)expr0.getOperandList().get(0);
        SqlNode toType = (SqlNode)expr0.getOperandList().get(1);
        RelDataType returnType = super.deriveType(scope, toType);
        if (returnType.isStruct()) {
            throw this.newValidationError(expr, IgniteResource.INSTANCE.dataTypeIsNotSupported(returnType.getSqlTypeName().getName()));
        }
        RelDataType operandType = this.deriveType(scope, castOperand);
        boolean bl = nullType = SqlTypeUtil.isNull((RelDataType)returnType) || SqlTypeUtil.isNull((RelDataType)operandType);
        if (nullType) {
            return;
        }
        returnType = this.typeFactory().createTypeWithNullability(returnType, operandType.isNullable());
        this.setValidatedNodeType(expr, returnType);
        if (castOperand instanceof SqlDynamicParam && operandType.getSqlTypeName() == SqlTypeName.DECIMAL && returnType.getSqlTypeName() == SqlTypeName.DECIMAL) {
            this.setDynamicParamType((SqlDynamicParam)castOperand, returnType);
            return;
        }
        RelDataType returnCustomType = returnType instanceof IgniteCustomType ? returnType : null;
        RelDataType operandCustomType = operandType instanceof IgniteCustomType ? operandType : null;
        IgniteCustomTypeCoercionRules coercionRules = this.typeFactory().getCustomTypeCoercionRules();
        boolean check = operandCustomType != null && returnCustomType != null ? SqlTypeUtil.equalSansNullability((RelDataTypeFactory)this.typeFactory, (RelDataType)operandType, (RelDataType)returnType) : (operandCustomType != null ? coercionRules.needToCast(returnType, (IgniteCustomType)operandCustomType) : (returnCustomType != null ? coercionRules.needToCast(operandType, (IgniteCustomType)returnCustomType) : SqlTypeUtil.canCastFrom((RelDataType)returnType, (RelDataType)operandType, (boolean)true)));
        if (!check) {
            throw this.newValidationError(expr, (Resources.ExInst<SqlValidatorException>)Static.RESOURCE.cannotCastValue(operandType.toString(), returnType.toString()));
        }
    }

    public void validateDataType(SqlDataTypeSpec dataType) {
        RelDataType type = dataType.deriveType((SqlValidator)this);
        if (SqlTypeUtil.isString((RelDataType)type) && type.getPrecision() == 0) {
            String typeName = type.getSqlTypeName().getSpaceName();
            throw this.newValidationError((SqlNode)dataType, IgniteResource.INSTANCE.invalidStringLength(typeName));
        }
        super.validateDataType(dataType);
    }

    protected void validateJoin(SqlJoin join, SqlValidatorScope scope) {
        if (join.getJoinType() == JoinType.ASOF || join.getJoinType() == JoinType.LEFT_ASOF) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported join type: " + join.getJoinType().toString().replace("_", " "));
        }
        super.validateJoin(join, scope);
        if (join.isNatural() || join.getConditionType() == JoinConditionType.USING) {
            this.validateJoinCondition(join);
        }
    }

    protected SqlNode performUnconditionalRewrites(SqlNode node, boolean underFrom) {
        SqlSelect select;
        if (node instanceof SqlSelect && (select = (SqlSelect)node).getFrom() instanceof SqlJoin) {
            boolean hasStar = false;
            for (SqlNode expr : select.getSelectList()) {
                if (!(expr instanceof SqlIdentifier) || !((SqlIdentifier)expr).isStar() || ((SqlIdentifier)expr).names.size() != 1) continue;
                hasStar = true;
            }
            this.performJoinRewrites((SqlJoin)select.getFrom(), hasStar);
        }
        return super.performUnconditionalRewrites(node, underFrom);
    }

    public SqlTypeMappingRule getTypeMappingRule() {
        return IgniteCustomAssignmentsRules.instance();
    }

    private void performJoinRewrites(SqlJoin join, boolean hasStar) {
        if (join.getLeft() instanceof SqlJoin) {
            this.performJoinRewrites((SqlJoin)join.getLeft(), hasStar || join.isNatural());
        }
        if (join.getRight() instanceof SqlJoin) {
            this.performJoinRewrites((SqlJoin)join.getRight(), hasStar || join.isNatural());
        }
        if (join.isNatural() || join.getConditionType() == JoinConditionType.USING && hasStar) {
            join.setLeft(this.rewriteTableToQuery(join.getLeft()));
            join.setRight(this.rewriteTableToQuery(join.getRight()));
        }
    }

    private SqlNode rewriteTableToQuery(SqlNode from) {
        SqlNode src;
        SqlNode sqlNode = src = from.getKind() == SqlKind.AS ? (SqlNode)((SqlCall)from).getOperandList().get(0) : from;
        if (src.getKind() == SqlKind.IDENTIFIER || src.getKind() == SqlKind.TABLE_REF) {
            String alias = this.deriveAlias(from, 0);
            SqlSelect expandedQry = new SqlSelect(SqlParserPos.ZERO, null, SqlNodeList.of((SqlNode)SqlIdentifier.star((SqlParserPos)SqlParserPos.ZERO)), src, null, null, null, null, null, null, null, null);
            return SqlValidatorUtil.addAlias((SqlNode)expandedQry, (String)alias);
        }
        return from;
    }

    private void validateJoinCondition(SqlJoin join) {
        SqlValidatorNamespace leftNs = this.getNamespace(join.getLeft());
        Objects.requireNonNull(leftNs, "leftNs");
        SqlValidatorNamespace rightNs = this.getNamespace(join.getRight());
        Objects.requireNonNull(leftNs, "rightNs");
        List joinColumnList = SqlValidatorUtil.deriveNaturalJoinColumnList((SqlNameMatcher)this.getCatalogReader().nameMatcher(), (RelDataType)leftNs.getRowType(), (RelDataType)rightNs.getRowType());
        if (joinColumnList.isEmpty()) {
            return;
        }
        for (int i = 0; i < joinColumnList.size(); ++i) {
            RelDataType rightType;
            String col = (String)joinColumnList.get(i);
            RelDataTypeField leftField = leftNs.getRowType().getField(col, true, false);
            RelDataTypeField rightField = rightNs.getRowType().getField(col, true, false);
            assert (leftField != null);
            assert (rightField != null);
            RelDataType leftType = leftField.getType();
            if (TypeUtils.typesRepresentTheSameColumnTypes(leftType, rightType = rightField.getType())) continue;
            throw this.newValidationError((SqlNode)join, IgniteResource.INSTANCE.naturalOrUsingColumnNotCompatible(i, leftType.toString(), rightType.toString()));
        }
    }

    private void validateAggregateFunction(SqlCall call, SqlAggFunction aggFunction) {
        if (!SqlKind.AGGREGATE.contains(aggFunction.kind)) {
            throw this.newValidationError((SqlNode)call, IgniteResource.INSTANCE.unsupportedAggregationFunction(aggFunction.getName()));
        }
        switch (aggFunction.kind) {
            case COUNT: {
                if (call.operandCount() > 1) {
                    throw this.newValidationError((SqlNode)call, (Resources.ExInst<SqlValidatorException>)Static.RESOURCE.invalidArgCount(aggFunction.getName(), 1));
                }
                return;
            }
            case SUM: 
            case AVG: 
            case MIN: 
            case MAX: 
            case ANY_VALUE: {
                return;
            }
        }
        throw this.newValidationError((SqlNode)call, IgniteResource.INSTANCE.unsupportedAggregationFunction(aggFunction.getName()));
    }

    private SqlNodeList inferColumnList(IgniteTable igniteTable) {
        SqlNodeList columnList = new SqlNodeList(SqlParserPos.ZERO);
        for (RelDataTypeField field : igniteTable.rowTypeForInsert(this.typeFactory()).getFieldList()) {
            columnList.add((SqlNode)new SqlIdentifier(field.getName(), SqlParserPos.ZERO));
        }
        return columnList;
    }

    private void validateUpdateFields(SqlUpdate call) {
        if (call.getTargetColumnList() == null) {
            return;
        }
        SqlValidatorNamespace ns = this.validatedNamespace((SqlNode)call, this.unknownType);
        SqlValidatorTable table = this.table(ns);
        IgniteTable igniteTable = this.getIgniteTableForModification((SqlIdentifier)call.getTargetTable(), table);
        RelDataType baseType = table.getRowType();
        RelOptTable relOptTable = this.relOptTable(ns);
        for (SqlNode node : call.getTargetColumnList()) {
            SqlIdentifier id = (SqlIdentifier)node;
            RelDataTypeField target = SqlValidatorUtil.getTargetField((RelDataType)baseType, (RelDataTypeFactory)this.typeFactory(), (SqlIdentifier)id, (SqlValidatorCatalogReader)this.getCatalogReader(), (RelOptTable)relOptTable);
            if (target == null) {
                throw this.newValidationError((SqlNode)id, (Resources.ExInst<SqlValidatorException>)Static.RESOURCE.unknownTargetColumn(id.toString()));
            }
            if (igniteTable.isUpdateAllowed(target.getIndex())) continue;
            throw this.newValidationError((SqlNode)id, IgniteResource.INSTANCE.cannotUpdateField(id.toString()));
        }
    }

    private SqlValidatorTable table(SqlValidatorNamespace ns) {
        RelOptTable relOptTable = this.relOptTable(ns);
        if (relOptTable != null) {
            return (SqlValidatorTable)relOptTable.unwrap(SqlValidatorTable.class);
        }
        return ns.getTable();
    }

    private RelOptTable relOptTable(SqlValidatorNamespace ns) {
        return SqlValidatorUtil.getRelOptTable((SqlValidatorNamespace)ns, (Prepare.CatalogReader)((Prepare.CatalogReader)this.getCatalogReader().unwrap(Prepare.CatalogReader.class)), null, null);
    }

    private SqlValidatorNamespace validatedNamespace(SqlNode node, RelDataType targetType) {
        SqlValidatorNamespace ns = this.getNamespace(node);
        this.validateNamespace(ns, targetType);
        return ns;
    }

    private IgniteTypeFactory typeFactory() {
        return (IgniteTypeFactory)this.typeFactory;
    }

    public static boolean isSystemFieldName(String alias) {
        return Commons.implicitPkEnabled() && "__p_key".equals(alias) || alias.equals("__part");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateValues(SqlCall node, RelDataType targetRowType, SqlValidatorScope scope) {
        this.callScopes.push(CallScope.VALUES);
        try {
            for (SqlNode rowConstructorNode : node.getOperandList()) {
                SqlCall rowConstructorCall = (SqlCall)rowConstructorNode;
                for (int i = 0; i < rowConstructorCall.operandCount(); ++i) {
                    SqlNode operand = rowConstructorCall.operand(i);
                    if (operand.getKind() != SqlKind.DEFAULT) continue;
                    this.setValidatedNodeType(operand, ((RelDataTypeField)targetRowType.getFieldList().get(i)).getType());
                }
            }
            super.validateValues(node, targetRowType, scope);
        }
        finally {
            this.callScopes.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateGroupClause(SqlSelect select) {
        SqlNodeList group = select.getGroup() == null ? SqlNodeList.EMPTY : select.getGroup();
        boolean rowInGroupScope = false;
        for (SqlNode node : group) {
            if (node.getKind() != SqlKind.GROUPING_SETS && node.getKind() != SqlKind.ROW) continue;
            rowInGroupScope = true;
            break;
        }
        if (!rowInGroupScope) {
            super.validateGroupClause(select);
        } else {
            this.callScopes.push(CallScope.GROUP);
            try {
                super.validateGroupClause(select);
            }
            finally {
                this.callScopes.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        boolean valuesCall;
        String alias;
        if (call.getKind() == SqlKind.AS && IgniteSqlValidator.isSystemFieldName(alias = this.deriveAlias((SqlNode)call, 0))) {
            throw this.newValidationError((SqlNode)call, IgniteResource.INSTANCE.illegalAlias(alias));
        }
        CallScope callScope = this.callScopes.peek();
        boolean validatingRowOperator = call.getOperator() == SqlStdOperatorTable.ROW;
        boolean insideValues = callScope == CallScope.VALUES;
        boolean insideGroupClause = callScope == CallScope.GROUP;
        boolean bl = valuesCall = call.getOperator() == SqlStdOperatorTable.VALUES;
        if (validatingRowOperator && !insideValues && !insideGroupClause) {
            throw this.newValidationError((SqlNode)call, IgniteResource.INSTANCE.dataTypeIsNotSupported(call.getOperator().getName()));
        }
        if (valuesCall) {
            this.callScopes.push(CallScope.VALUES);
        } else if (insideGroupClause) {
            this.callScopes.push(CallScope.GROUP);
        } else {
            this.callScopes.push(CallScope.OTHER);
        }
        try {
            super.validateCall(call, scope);
            this.checkCallsWithCustomTypes(call, scope);
        }
        finally {
            this.callScopes.pop();
        }
    }

    private void checkCallsWithCustomTypes(SqlCall call, SqlValidatorScope scope) {
        SqlOperator operator = call.getOperator();
        if (call.getOperandList().isEmpty() || !(operator instanceof SqlFunction) || IgniteSqlOperatorTable.CUSTOM_TYPE_FUNCTIONS.contains(operator)) {
            return;
        }
        for (SqlNode node : call.getOperandList()) {
            RelDataType type = this.getValidatedNodeTypeIfKnown(node);
            if (!(type instanceof IgniteCustomType)) continue;
            String name = call.getOperator().getName();
            if (operator.getOperandTypeChecker() != null) {
                String allowedSignatures = operator.getAllowedSignatures();
                throw this.newValidationError((SqlNode)call, (Resources.ExInst<SqlValidatorException>)Static.RESOURCE.canNotApplyOp2Type(name, call.getCallSignature((SqlValidator)this, scope), allowedSignatures));
            }
            throw this.newValidationError((SqlNode)call, IgniteResource.INSTANCE.canNotApplyOp2Type(name, call.getCallSignature((SqlValidator)this, scope)));
        }
    }

    protected void inferUnknownTypes(RelDataType inferredType, SqlValidatorScope scope, SqlNode node) {
        SqlCall call;
        if (node.getKind() == SqlKind.IS_NULL || node.getKind() == SqlKind.IS_NOT_NULL) {
            call = (SqlCall)node;
            if (this.isUnspecifiedDynamicParam(call.operand(0))) {
                SqlCallBinding binding = new SqlCallBinding((SqlValidator)this, scope, call);
                String signature = IgniteResource.makeSignature(binding, List.of(this.unknownType));
                throw binding.newValidationError(IgniteResource.INSTANCE.ambiguousOperator1(signature));
            }
        } else if (node.getKind() == SqlKind.IN && this.isUnspecifiedDynamicParam((call = (SqlCall)node).operand(0))) {
            SqlDynamicParam dynamicParam = (SqlDynamicParam)call.operand(0);
            throw this.newValidationError((SqlNode)dynamicParam, IgniteResource.INSTANCE.unableToResolveDynamicParameterType());
        }
        if (node instanceof SqlDynamicParam) {
            SqlDynamicParam dynamicParam = (SqlDynamicParam)node;
            this.inferDynamicParamType(inferredType, dynamicParam);
        } else {
            super.inferUnknownTypes(inferredType, scope, node);
        }
    }

    private void inferDynamicParamType(RelDataType inferredType, SqlDynamicParam dynamicParam) {
        RelDataType type = this.deriveDynamicParamTypeIfNotKnown(dynamicParam);
        if (inferredType == this.unknownType && type == this.unknownType) {
            this.setDynamicParamType(dynamicParam, this.unknownType);
        } else if (type != this.unknownType) {
            this.setDynamicParamType(dynamicParam, type);
        } else {
            RelDataType nullableType = this.typeFactory.createTypeWithNullability(inferredType, true);
            this.setDynamicParamType(dynamicParam, nullableType);
        }
    }

    private RelDataType deriveDynamicParamTypeIfNotKnown(SqlDynamicParam dynamicParam) {
        RelDataType validatedNodeType = this.getValidatedNodeTypeIfKnown((SqlNode)dynamicParam);
        if (validatedNodeType != null) {
            return validatedNodeType;
        }
        return this.deriveDynamicParamType(dynamicParam);
    }

    private RelDataType deriveDynamicParamType(SqlDynamicParam dynamicParam) {
        this.dynamicParamNodes.put(dynamicParam, dynamicParam);
        if (this.isUnspecified(dynamicParam)) {
            this.setDynamicParamType(dynamicParam, this.unknownType);
            return this.unknownType;
        }
        Object value = this.getDynamicParamValue(dynamicParam);
        RelDataType parameterType = this.deriveTypeFromDynamicParamValue(value);
        RelDataType nullableType = this.typeFactory.createTypeWithNullability(parameterType, true);
        this.setDynamicParamType(dynamicParam, nullableType);
        return nullableType;
    }

    private RelDataType deriveTypeFromDynamicParamValue(@Nullable Object value) {
        if (value == null) {
            return this.typeFactory.createSqlType(SqlTypeName.NULL);
        }
        Class<Object> valueClass = value.getClass();
        if (valueClass == Character.class) {
            valueClass = String.class;
        }
        NativeTypeSpec spec = NativeTypeSpec.fromClass(valueClass);
        assert (spec != null) : "Unable to derive type from value: " + String.valueOf(value);
        switch (spec) {
            case INT8: {
                return this.typeFactory.createSqlType(SqlTypeName.TINYINT);
            }
            case INT16: {
                return this.typeFactory.createSqlType(SqlTypeName.SMALLINT);
            }
            case INT32: {
                return this.typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case INT64: {
                return this.typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            case FLOAT: {
                return this.typeFactory.createSqlType(SqlTypeName.REAL);
            }
            case DOUBLE: {
                return this.typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            case BOOLEAN: {
                return this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case UUID: {
                return this.typeFactory().createCustomType("UUID");
            }
            case DATE: {
                return this.typeFactory.createSqlType(SqlTypeName.DATE);
            }
            case TIME: {
                return this.typeFactory.createSqlType(SqlTypeName.TIME);
            }
            case DATETIME: {
                return this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
            case TIMESTAMP: {
                return this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
            }
            case DECIMAL: {
                return this.typeFactory.createSqlType(SqlTypeName.DECIMAL, 28, 6);
            }
            case BYTES: {
                return this.typeFactory.createSqlType(SqlTypeName.VARBINARY, -1);
            }
            case STRING: {
                return this.typeFactory.createSqlType(SqlTypeName.VARCHAR, -1);
            }
        }
        throw new AssertionError((Object)("Unknown type " + String.valueOf(spec)));
    }

    RelDataType resolveDynamicParameterType(SqlDynamicParam dynamicParam, RelDataType contextType) {
        if (this.isUnspecified(dynamicParam)) {
            RelDataType nullableContextType = this.typeFactory.createTypeWithNullability(contextType, true);
            this.setDynamicParamType(dynamicParam, nullableContextType);
            return nullableContextType;
        }
        return this.deriveDynamicParamTypeIfNotKnown(dynamicParam);
    }

    private void setDynamicParamType(SqlDynamicParam dynamicParam, RelDataType dataType) {
        this.setValidatedNodeType((SqlNode)dynamicParam, dataType);
        this.setDynamicParamResolvedType(dynamicParam, dataType);
    }

    @Nullable
    private Object getDynamicParamValue(SqlDynamicParam dynamicParam) {
        int index = dynamicParam.getIndex();
        DynamicParamState paramState = (DynamicParamState)this.dynamicParameters.computeIfAbsent(index, i -> new DynamicParamState());
        Object value = paramState.value;
        if (!paramState.hasValue) {
            throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Value of dynamic parameter#{} is not specified", (Object[])new Object[]{index}));
        }
        return value;
    }

    private void validateInferredDynamicParameters() {
        for (int i = 0; i < this.dynamicParameters.size(); ++i) {
            DynamicParamState paramState = (DynamicParamState)this.dynamicParameters.get(i);
            if (paramState == null || paramState.resolvedType == null || paramState.node == null) {
                throw new AssertionError((Object)("Dynamic parameter has not been validated: " + i));
            }
            if (paramState.resolvedType != this.unknownType) continue;
            throw this.newValidationError((SqlNode)paramState.node, IgniteResource.INSTANCE.unableToResolveDynamicParameterType());
        }
        for (SqlDynamicParam node : this.dynamicParamNodes.keySet()) {
            RelDataType derivedType;
            RelDataType paramType;
            int i = node.getIndex();
            DynamicParamState state = (DynamicParamState)this.dynamicParameters.get(i);
            if (!state.hasValue || Objects.equals(paramType = state.resolvedType, derivedType = this.getValidatedNodeTypeIfKnown((SqlNode)node))) continue;
            String message = IgniteStringFormatter.format((String)"Type of dynamic parameter node#{} does not match. Expected: {} derived: {}", (Object[])new Object[]{i, paramType.getFullTypeString(), derivedType != null ? derivedType.getFullTypeString() : null});
            throw new AssertionError((Object)message);
        }
    }

    private void setDynamicParamResolvedType(SqlDynamicParam param, RelDataType type) {
        int index = param.getIndex();
        DynamicParamState state = (DynamicParamState)this.dynamicParameters.computeIfAbsent(index, i -> new DynamicParamState());
        state.node = param;
        state.resolvedType = type;
    }

    public boolean isUnspecified(SqlDynamicParam param) {
        int index = param.getIndex();
        DynamicParamState state = (DynamicParamState)this.dynamicParameters.computeIfAbsent(index, i -> new DynamicParamState());
        return !state.hasValue;
    }

    public boolean isUnspecifiedDynamicParam(SqlNode node) {
        if (node.getKind() != SqlKind.DYNAMIC_PARAM) {
            return false;
        }
        return this.isUnspecified((SqlDynamicParam)node);
    }

    static {
        EnumSet<SqlKind> kinds = EnumSet.noneOf(SqlKind.class);
        kinds.addAll(SqlKind.AGGREGATE);
        kinds.addAll(SqlKind.BINARY_ARITHMETIC);
        kinds.addAll(SqlKind.FUNCTION);
        kinds.add(SqlKind.CEIL);
        kinds.add(SqlKind.FLOOR);
        kinds.add(SqlKind.LITERAL);
        kinds.add(SqlKind.PROCEDURE_CALL);
        HUMAN_READABLE_ALIASES_FOR = Collections.unmodifiableSet(kinds);
    }

    private static final class DynamicParamState {
        final Object value;
        final boolean hasValue;
        SqlDynamicParam node;
        RelDataType resolvedType;

        private DynamicParamState(@Nullable Object value) {
            this.value = value;
            this.hasValue = true;
        }

        private DynamicParamState() {
            this.value = null;
            this.hasValue = false;
        }
    }

    private static enum CallScope {
        VALUES,
        GROUP,
        OTHER;

    }
}

