/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.agg;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.util.Commons;

interface IgniteSortAggregateBase
extends TraitsAwareIgniteRel {
    public ImmutableBitSet getGroupSet();

    @Override
    default public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelCollation required = TraitUtils.collation(nodeTraits);
        if (this.getGroupSet().isEmpty()) {
            return Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), List.of(inputTraits.get(0).replace((RelTrait)RelCollations.EMPTY)));
        }
        if (required.getFieldCollations().isEmpty()) {
            return this.passThroughDefaultCollation(nodeTraits, inputTraits);
        }
        int groupingColumnsSize = this.getGroupSet().cardinality();
        IntList prefix = Commons.maxPrefix(required.getKeys(), ImmutableIntList.range((int)0, (int)groupingColumnsSize));
        if (prefix.isEmpty()) {
            return this.passThroughDefaultCollation(nodeTraits, inputTraits);
        }
        ArrayList outputCollationColumns = new ArrayList(groupingColumnsSize);
        outputCollationColumns.addAll(required.getFieldCollations().subList(0, prefix.size()));
        IntPredicate isPrefixColumn = arg_0 -> ((IntList)prefix).contains(arg_0);
        IntStream.range(0, groupingColumnsSize).filter(isPrefixColumn.negate()).mapToObj(TraitUtils::createFieldCollation).forEachOrdered(outputCollationColumns::add);
        Mapping mapping = Commons.trimmingMapping(this.getGroupSet().length(), this.getGroupSet()).inverse();
        RelCollation outputCollation = RelCollations.of(outputCollationColumns);
        RelCollation inputCollation = RelCollations.permute((RelCollation)outputCollation, (Mappings.TargetMapping)mapping);
        return Pair.of((Object)nodeTraits.replace((RelTrait)outputCollation), List.of(inputTraits.get(0).replace((RelTrait)inputCollation)));
    }

    private Pair<RelTraitSet, List<RelTraitSet>> passThroughDefaultCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelCollation inputCollation = TraitUtils.createCollation(this.getGroupSet().asList());
        RelCollation outputCollation = TraitUtils.createCollation(ImmutableIntList.range((int)0, (int)this.getGroupSet().cardinality()));
        return Pair.of((Object)nodeTraits.replace((RelTrait)outputCollation), List.of(inputTraits.get(0).replace((RelTrait)inputCollation)));
    }

    @Override
    default public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelCollation inputCollation = TraitUtils.collation(inputTraits.get(0));
        IntList newCollationColls = Commons.maxPrefix(inputCollation.getKeys(), this.getGroupSet().asSet());
        if (newCollationColls.size() < this.getGroupSet().cardinality()) {
            return List.of();
        }
        List suitableCollations = inputCollation.getFieldCollations().stream().filter(k -> newCollationColls.contains(k.getFieldIndex())).collect(Collectors.toList());
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.of(suitableCollations)), inputTraits));
    }
}

