/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomTypeSpec;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.type.NativeTypeSpec;
import org.jetbrains.annotations.Nullable;

final class SafeCustomTypeInternalConversion {
    static final SafeCustomTypeInternalConversion INSTANCE = new SafeCustomTypeInternalConversion(Commons.typeFactory());
    private final Map<NativeTypeSpec, Class<?>> internalTypes;

    private SafeCustomTypeInternalConversion(IgniteTypeFactory typeFactory) {
        Map<String, IgniteCustomTypeSpec> customTypes = typeFactory.getCustomTypeSpecs();
        this.internalTypes = customTypes.values().stream().map(t -> Map.entry(t.nativeType().spec(), t.storageType())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nullable
    Object tryConvertToInternal(Object val, NativeTypeSpec storageType) {
        Class<?> internalType = this.internalTypes.get(storageType);
        if (internalType == null) {
            return null;
        }
        assert (internalType.isInstance(val)) : SafeCustomTypeInternalConversion.storageTypeMismatch(val, internalType);
        return val;
    }

    @Nullable
    Object tryConvertFromInternal(Object val, NativeTypeSpec storageType) {
        Class<?> internalType = this.internalTypes.get(storageType);
        if (internalType == null) {
            return null;
        }
        assert (internalType.isInstance(val)) : SafeCustomTypeInternalConversion.storageTypeMismatch(val, internalType);
        return val;
    }

    private static String storageTypeMismatch(Object value, Class<?> type) {
        return String.format("storageType is %s value must also be %s but it was: %s", type, type, value);
    }
}

