/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospectionMap;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Map;

public interface BeanMap<T>
extends Map<String, Object> {
    @NonNull
    public Class<T> getBeanType();

    @NonNull
    public static <B> BeanMap<B> of(@NonNull B bean) {
        ArgumentUtils.requireNonNull("bean", bean);
        BeanIntrospection<?> introspection = BeanIntrospector.SHARED.getIntrospection(bean.getClass());
        return new BeanIntrospectionMap(introspection, bean);
    }
}

