/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.decorators;

import com.jakewharton.fliptables.FlipTable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.internal.cli.util.PlainTableRenderer;
import org.apache.ignite.rest.client.model.UnitStatus;
import org.apache.ignite.rest.client.model.UnitVersionStatus;

public class UnitListDecorator
implements Decorator<List<UnitStatus>, TerminalOutput> {
    private static final String[] HEADERS = new String[]{"id", "version", "status"};
    private final boolean plain;

    public UnitListDecorator(boolean plain) {
        this.plain = plain;
    }

    @Override
    public TerminalOutput decorate(List<UnitStatus> data) {
        if (this.plain) {
            return () -> PlainTableRenderer.render(HEADERS, UnitListDecorator.toContent(data));
        }
        return () -> FlipTable.of((String[])HEADERS, (String[][])UnitListDecorator.toContent(data));
    }

    private static String[][] toContent(List<UnitStatus> data) {
        return (String[][])data.stream().flatMap(UnitListDecorator::unfoldRecordWithVersions).toArray(x$0 -> new String[x$0][]);
    }

    private static Stream<String[]> unfoldRecordWithVersions(UnitStatus status) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        List<UnitVersionStatus> versionStatuses = status.getVersionToStatus();
        int size = versionStatuses.size();
        for (int i = 0; i < size; ++i) {
            UnitVersionStatus entry = versionStatuses.get(i);
            result.add(new String[]{status.getId(), (i == size - 1 ? "*" : "") + entry.getVersion(), entry.getStatus().getValue()});
        }
        return result.stream();
    }
}

