/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.hlc;

import java.util.concurrent.CompletableFuture;
import java.util.function.LongSupplier;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.ClockWaiter;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;

public class ClockServiceImpl
implements ClockService {
    private final HybridClock clock;
    private final ClockWaiter clockWaiter;
    private final LongSupplier maxClockSkewMsSupplier;

    public ClockServiceImpl(HybridClock clock, ClockWaiter clockWaiter, LongSupplier maxClockSkewMsSupplier) {
        this.clock = clock;
        this.clockWaiter = clockWaiter;
        this.maxClockSkewMsSupplier = maxClockSkewMsSupplier;
    }

    @Override
    public HybridTimestamp now() {
        return this.clock.now();
    }

    @Override
    public HybridTimestamp current() {
        return this.clock.current();
    }

    @Override
    public long nowLong() {
        return this.clock.nowLong();
    }

    @Override
    public long currentLong() {
        return this.clock.currentLong();
    }

    @Override
    public HybridTimestamp updateClock(HybridTimestamp requestTime) {
        return this.clock.update(requestTime);
    }

    @Override
    public CompletableFuture<Void> waitFor(HybridTimestamp targetTimestamp) {
        return this.clockWaiter.waitFor(targetTimestamp);
    }

    @Override
    public long maxClockSkewMillis() {
        return this.maxClockSkewMsSupplier.getAsLong();
    }
}

