/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.LabelNode;
import java.util.List;
import java.util.Objects;

class InlineIfBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression condition;
    private final BytecodeExpression ifTrue;
    private final BytecodeExpression ifFalse;

    InlineIfBytecodeExpression(BytecodeExpression condition, BytecodeExpression ifTrue, BytecodeExpression ifFalse) {
        super(ifTrue.getType());
        this.condition = condition;
        this.ifTrue = Objects.requireNonNull(ifTrue, "ifTrue is null");
        this.ifFalse = Objects.requireNonNull(ifFalse, "ifFalse is null");
        BytecodeUtils.checkArgument(condition.getType().getPrimitiveType() == Boolean.TYPE, "Expected condition to be type boolean but is %s", condition.getType());
        BytecodeUtils.checkArgument(ifTrue.getType().equals(ifFalse.getType()), "Expected ifTrue and ifFalse to be the same type", new Object[0]);
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        LabelNode falseLabel = new LabelNode("false");
        LabelNode endLabel = new LabelNode("end");
        return new BytecodeBlock().append(this.condition).ifFalseGoto(falseLabel).append(this.ifTrue).gotoLabel(endLabel).visitLabel(falseLabel).append(this.ifFalse).visitLabel(endLabel);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of(this.condition, this.ifTrue, this.ifFalse);
    }

    @Override
    protected String formatOneLine() {
        return "(" + String.valueOf(this.condition) + " ? " + String.valueOf(this.ifTrue) + " : " + String.valueOf(this.ifFalse) + ")";
    }
}

