/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.messaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.message.MetricDisableRequest;
import org.apache.ignite.internal.metrics.message.MetricDisableResponse;
import org.apache.ignite.internal.metrics.message.MetricEnableRequest;
import org.apache.ignite.internal.metrics.message.MetricEnableResponse;
import org.apache.ignite.internal.metrics.message.MetricSourceDto;
import org.apache.ignite.internal.metrics.message.MetricSourcesRequest;
import org.apache.ignite.internal.metrics.message.MetricSourcesResponse;
import org.apache.ignite.internal.metrics.messaging.MetricMessageTypes;
import org.apache.ignite.internal.metrics.messaging.MetricMessagesFactory;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class MetricMessaging
implements IgniteComponent {
    private static final long NETWORK_TIMEOUT_MILLIS = Long.MAX_VALUE;
    private final MetricMessagesFactory messagesFactory = new MetricMessagesFactory();
    private final MetricManager metricManager;
    private final MessagingService messagingService;
    private final TopologyService topologyService;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();

    public MetricMessaging(MetricManager metricManager, MessagingService messagingService, TopologyService topologyService) {
        this.metricManager = metricManager;
        this.messagingService = messagingService;
        this.topologyService = topologyService;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.messagingService.addMessageHandler(MetricMessageTypes.class, (message, sender, correlationId) -> {
            assert (correlationId != null);
            if (!this.busyLock.enterBusy()) {
                this.sendException(message, sender, Objects.requireNonNull(correlationId, "correlationId is null"), new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException()));
                return;
            }
            try {
                this.processRequest(message, sender, Objects.requireNonNull(correlationId));
            }
            finally {
                this.busyLock.leaveBusy();
            }
        });
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.busyLock.block();
        return CompletableFutures.nullCompletedFuture();
    }

    private void sendException(NetworkMessage message, InternalClusterNode sender, long correlationId, IgniteInternalException ex) {
        if (message instanceof MetricEnableRequest) {
            this.sendEnableResponse((Throwable)ex, sender, correlationId);
        } else if (message instanceof MetricDisableRequest) {
            this.sendDisableResponse((Throwable)ex, sender, correlationId);
        } else if (message instanceof MetricSourcesRequest) {
            this.sendSourcesResponse(null, (Throwable)ex, sender, correlationId);
        }
    }

    private void processRequest(NetworkMessage message, InternalClusterNode sender, long correlationId) {
        if (message instanceof MetricEnableRequest) {
            this.processEnableRequest((MetricEnableRequest)message, sender, correlationId);
        } else if (message instanceof MetricDisableRequest) {
            this.processDisableRequest((MetricDisableRequest)message, sender, correlationId);
        } else if (message instanceof MetricSourcesRequest) {
            this.processSourcesRequest(sender, correlationId);
        }
    }

    private void processEnableRequest(MetricEnableRequest request, InternalClusterNode sender, long correlationId) {
        try {
            this.metricManager.enable(request.sourceName());
            this.sendEnableResponse(null, sender, correlationId);
        }
        catch (IllegalStateException e) {
            this.sendEnableResponse(e, sender, correlationId);
        }
    }

    private void sendEnableResponse(@Nullable Throwable ex, InternalClusterNode sender, long correlationId) {
        MetricEnableResponse enableResponse = this.messagesFactory.metricEnableResponse().throwable(ex).build();
        this.respond(sender, enableResponse, correlationId);
    }

    private void processDisableRequest(MetricDisableRequest request, InternalClusterNode sender, long correlationId) {
        try {
            this.metricManager.disable(request.sourceName());
            this.sendDisableResponse(null, sender, correlationId);
        }
        catch (IllegalStateException e) {
            this.sendDisableResponse(e, sender, correlationId);
        }
    }

    private void sendDisableResponse(@Nullable Throwable ex, InternalClusterNode sender, long correlationId) {
        MetricDisableResponse disableResponse = this.messagesFactory.metricDisableResponse().throwable(ex).build();
        this.respond(sender, disableResponse, correlationId);
    }

    private void processSourcesRequest(InternalClusterNode sender, long correlationId) {
        List<MetricSourceDto> sources = this.metricManager.metricSources().stream().map(source -> new MetricSourceDto(source.name(), source.enabled())).collect(Collectors.toList());
        this.sendSourcesResponse(sources, null, sender, correlationId);
    }

    private void sendSourcesResponse(@Nullable Collection<MetricSourceDto> sources, @Nullable Throwable ex, InternalClusterNode sender, long correlationId) {
        MetricSourcesResponse disableResponse = this.messagesFactory.metricSourcesResponse().sources(sources).throwable(ex).build();
        this.respond(sender, disableResponse, correlationId);
    }

    public CompletableFuture<Void> broadcastMetricEnableAsync(String sourceName) {
        return this.broadcastAsync(node -> this.remoteMetricEnableAsync((InternalClusterNode)node, sourceName));
    }

    private CompletableFuture<Void> remoteMetricEnableAsync(InternalClusterNode remoteNode, String sourceName) {
        MetricEnableRequest metricEnableRequest = this.messagesFactory.metricEnableRequest().sourceName(sourceName).build();
        return this.invoke(remoteNode, metricEnableRequest).thenCompose(MetricMessaging::fromEnableResponse);
    }

    private static CompletableFuture<Void> fromEnableResponse(NetworkMessage response) {
        Throwable throwable = ((MetricEnableResponse)response).throwable();
        return throwable != null ? CompletableFuture.failedFuture(throwable) : CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> broadcastMetricDisableAsync(String sourceName) {
        return this.broadcastAsync(node -> this.remoteMetricDisableAsync((InternalClusterNode)node, sourceName));
    }

    private CompletableFuture<Void> remoteMetricDisableAsync(InternalClusterNode remoteNode, String sourceName) {
        MetricDisableRequest metricDisableRequest = this.messagesFactory.metricDisableRequest().sourceName(sourceName).build();
        return this.invoke(remoteNode, metricDisableRequest).thenCompose(MetricMessaging::fromDisableResponse);
    }

    private static CompletableFuture<Void> fromDisableResponse(NetworkMessage response) {
        Throwable throwable = ((MetricDisableResponse)response).throwable();
        return throwable != null ? CompletableFuture.failedFuture(throwable) : CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Map<String, Collection<MetricSourceDto>>> broadcastMetricSourcesAsync() {
        ArrayList allMembers = new ArrayList(this.topologyService.allMembers());
        CompletableFuture[] futures = (CompletableFuture[])allMembers.stream().map(this::remoteMetricSourcesAsync).toArray(CompletableFuture[]::new);
        return CompletableFutures.allOfToList((CompletableFuture[])futures).thenApply(sources -> {
            HashMap<String, Collection> result = new HashMap<String, Collection>();
            for (int i = 0; i < allMembers.size(); ++i) {
                InternalClusterNode node = (InternalClusterNode)allMembers.get(i);
                result.put(node.name(), (Collection)sources.get(i));
            }
            return result;
        });
    }

    private CompletableFuture<Collection<MetricSourceDto>> remoteMetricSourcesAsync(InternalClusterNode remoteNode) {
        return this.invoke(remoteNode, this.messagesFactory.metricSourcesRequest().build()).thenCompose(response -> MetricMessaging.sourcesFromSourcesResponse((MetricSourcesResponse)response));
    }

    private static CompletableFuture<Collection<MetricSourceDto>> sourcesFromSourcesResponse(MetricSourcesResponse metricSourcesResponse) {
        Throwable throwable = metricSourcesResponse.throwable();
        return throwable != null ? CompletableFuture.failedFuture(throwable) : CompletableFuture.completedFuture(metricSourcesResponse.sources());
    }

    private CompletableFuture<Void> broadcastAsync(Function<InternalClusterNode, CompletableFuture<Void>> request) {
        CompletableFuture[] futures = (CompletableFuture[])this.topologyService.allMembers().stream().map(request).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    private CompletableFuture<NetworkMessage> invoke(InternalClusterNode remoteNode, NetworkMessage msg) {
        return this.messagingService.invoke(remoteNode.name(), msg, Long.MAX_VALUE);
    }

    private void respond(InternalClusterNode sender, NetworkMessage msg, long correlationId) {
        this.messagingService.respond(sender.name(), msg, correlationId);
    }
}

