/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence.mappers;

import java.util.Map;
import org.apache.ignite.migrationtools.persistence.mappers.RecordAndTableSchemaMismatchException;
import org.apache.ignite.migrationtools.persistence.mappers.SchemaColumnProcessorStats;
import org.apache.ignite.migrationtools.persistence.mappers.SimpleSchemaColumnsProcessor;
import org.apache.ignite.migrationtools.types.converters.TypeConverterFactory;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipRecordsSchemaColumnsProcessor
extends SimpleSchemaColumnsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipRecordsSchemaColumnsProcessor.class);
    private long skippedRecords = 0L;

    public SkipRecordsSchemaColumnsProcessor(ClientSchema schema, Map<String, String> fieldNameForColumn, TypeConverterFactory nativeTypeConverters) {
        super(schema, fieldNameForColumn, nativeTypeConverters);
    }

    @Override
    public SchemaColumnProcessorStats getStats() {
        SchemaColumnProcessorStats superStats = super.getStats();
        return new SkippedRecordsStats(superStats.getProcessedElements(), this.skippedRecords);
    }

    @Override
    public void onError(Throwable ex) {
        if (ex instanceof RecordAndTableSchemaMismatchException) {
            LOGGER.warn("Error matching cache record to table schema. Skipping entire record.", ex);
            ++this.skippedRecords;
            this.subscription.request(1L);
        } else {
            super.onError(ex);
        }
    }

    public static class SkippedRecordsStats
    extends SchemaColumnProcessorStats {
        private long numSkippedRecords;

        private SkippedRecordsStats() {
        }

        public SkippedRecordsStats(long processedElements, long numSkippedRecords) {
            super(processedElements);
            this.numSkippedRecords = numSkippedRecords;
        }

        public long getNumSkippedRecords() {
            return this.numSkippedRecords;
        }

        @Override
        public String toString() {
            return "SkippedRecordsStats{numProcessedRecords=" + this.getProcessedElements() + " ,numSkippedRecords=" + this.numSkippedRecords + "}";
        }
    }
}

