/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.graph;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import org.apache.ignite.internal.cluster.graph.BitSetIterator;
import org.apache.ignite.internal.util.typedef.F;

public class FullyConnectedComponentSearcher {
    private static final int BRUTE_FORCE_THRESHOULD = 24;
    private final int totalNodesCnt;
    private final BitSet[] connections;

    public FullyConnectedComponentSearcher(BitSet[] connections) {
        this.connections = connections;
        this.totalNodesCnt = connections.length;
    }

    public BitSet findLargest(BitSet where) {
        int nodesCnt = where.cardinality();
        if (nodesCnt <= 24) {
            return this.bruteforce(nodesCnt, where);
        }
        BitSet e1 = this.heuristic1(where);
        BitSet e2 = this.heuristic2(where);
        return e1.cardinality() > e2.cardinality() ? e1 : e2;
    }

    private Integer[] extractNodeIndexes(int selectedNodesCnt, BitSet selectedSet) {
        Integer[] indexes = new Integer[selectedNodesCnt];
        BitSetIterator it = new BitSetIterator(selectedSet);
        int i = 0;
        while (it.hasNext()) {
            indexes[i++] = (Integer)it.next();
        }
        assert (i == indexes.length) : "Extracted not all indexes [nodesCnt=" + selectedNodesCnt + ", extracted=" + i + ", set=" + selectedSet + "]";
        return indexes;
    }

    private BitSet heuristic1(BitSet selectedSet) {
        int selectedNodesCnt = selectedSet.cardinality();
        Integer[] nodeIndexes = this.extractNodeIndexes(selectedNodesCnt, selectedSet);
        Arrays.sort(nodeIndexes, new ConnectionsComparator(this.totalNodesCnt));
        return this.greedyIterative(selectedNodesCnt, nodeIndexes);
    }

    private BitSet heuristic2(BitSet selectedSet) {
        int selectedNodesCnt = selectedSet.cardinality();
        Integer[] nodeIndexes = this.extractNodeIndexes(selectedNodesCnt, selectedSet);
        Arrays.sort(nodeIndexes, new ConnectionsComparator(this.totalNodesCnt).reversed());
        return this.greedyIterative(selectedNodesCnt, nodeIndexes);
    }

    private BitSet greedyIterative(int selectedNodesCnt, Integer[] nodeIndexes) {
        BitSet canUse = new BitSet(selectedNodesCnt);
        for (int i = 0; i < selectedNodesCnt; ++i) {
            canUse.set(i);
        }
        BitSet bestRes = null;
        while (!(canUse.isEmpty() || bestRes != null && canUse.cardinality() <= bestRes.cardinality())) {
            BitSet currRes = new BitSet(selectedNodesCnt);
            BitSetIterator canUseIter = new BitSetIterator(canUse);
            while (canUseIter.hasNext()) {
                int pickedIdx = (Integer)canUseIter.next();
                if (!this.joinNode(currRes, pickedIdx, nodeIndexes)) continue;
                currRes.set(pickedIdx);
                canUse.set(pickedIdx, false);
            }
            if (bestRes != null && currRes.cardinality() <= bestRes.cardinality()) continue;
            bestRes = currRes;
        }
        for (int nodeIdx = 0; nodeIdx < selectedNodesCnt; ++nodeIdx) {
            if (bestRes.get(nodeIdx) || !this.joinNode(bestRes, nodeIdx, nodeIndexes)) continue;
            bestRes.set(nodeIdx);
        }
        BitSet reindexedBestRes = new BitSet(this.totalNodesCnt);
        BitSetIterator it = new BitSetIterator(bestRes);
        while (it.hasNext()) {
            reindexedBestRes.set(nodeIndexes[(Integer)it.next()]);
        }
        return reindexedBestRes;
    }

    private boolean joinNode(BitSet currComponent, int nodeIdx, Integer[] nodeIndexes) {
        boolean fullyConnected = true;
        BitSetIterator alreadyUsedIter = new BitSetIterator(currComponent);
        while (alreadyUsedIter.hasNext()) {
            int existedIdx = (Integer)alreadyUsedIter.next();
            if (this.connections[nodeIndexes[nodeIdx]].get(nodeIndexes[existedIdx])) continue;
            fullyConnected = false;
            break;
        }
        return fullyConnected;
    }

    private BitSet bruteforce(int selectedNodesCnt, BitSet selectedSet) {
        Integer[] indexes = this.extractNodeIndexes(selectedNodesCnt, selectedSet);
        int resMask = -1;
        int maxCardinality = -1;
        for (int mask = (1 << selectedNodesCnt) - 1; mask > 0; --mask) {
            int cardinality = Integer.bitCount(mask);
            if (cardinality <= maxCardinality) continue;
            boolean fullyConnected = true;
            block1: for (int i = 0; i < selectedNodesCnt && fullyConnected; ++i) {
                if ((mask & 1 << i) == 0) continue;
                for (int j = 0; j < selectedNodesCnt; ++j) {
                    boolean connected;
                    if ((mask & 1 << j) == 0 || (connected = this.connections[indexes[i]].get(indexes[j]))) continue;
                    fullyConnected = false;
                    continue block1;
                }
            }
            if (!fullyConnected) continue;
            resMask = mask;
            maxCardinality = cardinality;
        }
        BitSet resSet = new BitSet(selectedNodesCnt);
        for (int i = 0; i < selectedNodesCnt; ++i) {
            if ((resMask & 1 << i) == 0) continue;
            int idx = indexes[i];
            assert (selectedSet.get(idx)) : "Result contains node which is not presented in income set [nodeIdx" + idx + ", set=" + selectedSet + "]";
            resSet.set(idx);
        }
        assert (resSet.cardinality() > 0) : "No nodes selected as fully connected component [set=" + selectedSet + "]";
        return resSet;
    }

    private class ConnectionsComparator
    implements Comparator<Integer> {
        private final long[][] cachedConnRows;

        ConnectionsComparator(int totalNodesCnt) {
            this.cachedConnRows = new long[totalNodesCnt][];
        }

        private long[] connectionRow(int idx) {
            if (this.cachedConnRows[idx] != null) {
                return this.cachedConnRows[idx];
            }
            this.cachedConnRows[idx] = FullyConnectedComponentSearcher.this.connections[idx].toLongArray();
            return this.cachedConnRows[idx];
        }

        @Override
        public int compare(Integer node1, Integer node2) {
            return F.compareArrays(this.connectionRow(node1), this.connectionRow(node2));
        }
    }
}

