/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ssl.AbstractSslContextFactory;

public class SslContextFactory
extends AbstractSslContextFactory {
    private static final long serialVersionUID = 0L;
    public static final String DFLT_STORE_TYPE = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
    public static final String DFLT_SSL_PROTOCOL = "TLS";
    public static final String DFLT_KEY_ALGORITHM = System.getProperty("ssl.KeyManagerFactory.algorithm", "SunX509");
    protected String keyAlgorithm = DFLT_KEY_ALGORITHM;
    protected String keyStoreType = DFLT_STORE_TYPE;
    protected String keyStoreFilePath;
    protected char[] keyStorePwd;
    protected String trustStoreType = DFLT_STORE_TYPE;
    protected String trustStoreFilePath;
    protected char[] trustStorePwd;
    protected TrustManager[] trustMgrs;

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        A.notNull(keyStoreType, "keyStoreType");
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        A.notNull(trustStoreType, "trustStoreType");
        this.trustStoreType = trustStoreType;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        A.notNull(keyAlgorithm, "keyAlgorithm");
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public void setKeyStoreFilePath(String keyStoreFilePath) {
        A.notNull(keyStoreFilePath, "keyStoreFilePath");
        this.keyStoreFilePath = keyStoreFilePath;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePwd;
    }

    public void setKeyStorePassword(char[] keyStorePwd) {
        A.notNull(keyStorePwd, "keyStorePwd");
        this.keyStorePwd = keyStorePwd;
    }

    public String getTrustStoreFilePath() {
        return this.trustStoreFilePath;
    }

    public void setTrustStoreFilePath(String trustStoreFilePath) {
        this.trustStoreFilePath = trustStoreFilePath;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePwd;
    }

    public void setTrustStorePassword(char[] trustStorePwd) {
        this.trustStorePwd = trustStorePwd;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustMgrs;
    }

    public void setTrustManagers(TrustManager ... trustMgrs) {
        this.trustMgrs = trustMgrs;
    }

    public static TrustManager getDisabledTrustManager() {
        return new DisabledX509TrustManager();
    }

    @Override
    protected final KeyManager[] createKeyManagers() throws SSLException {
        try {
            KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(this.keyAlgorithm);
            KeyStore keyStore = this.loadKeyStore(this.keyStoreType, this.keyStoreFilePath, this.keyStorePwd);
            keyMgrFactory.init(keyStore, this.keyStorePwd);
            return keyMgrFactory.getKeyManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLException("Unsupported key algorithm: " + this.keyAlgorithm, e);
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Failed to initialize Key Manager (security exception occurred) [type=" + this.keyStoreType + ", keyStorePath=" + this.keyStoreFilePath + "]", e);
        }
    }

    @Override
    protected final TrustManager[] createTrustManagers() throws SSLException {
        if (this.trustMgrs != null) {
            return this.trustMgrs;
        }
        KeyStore trustStore = this.loadKeyStore(this.trustStoreType, this.trustStoreFilePath, this.trustStorePwd);
        try {
            TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(this.keyAlgorithm);
            trustMgrFactory.init(trustStore);
            return trustMgrFactory.getTrustManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLException("Unsupported key algorithm: " + this.keyAlgorithm, e);
        }
        catch (GeneralSecurityException e) {
            throw new SSLException("Failed to initialize Trust Manager (security exception occurred) [type=" + this.trustStoreType + ", trustStorePath=" + this.trustStoreFilePath + "]", e);
        }
    }

    private String parameters() {
        StringBuilder buf = new StringBuilder("[keyStoreType=").append(this.keyStoreType);
        buf.append(", proto=").append(this.proto).append(", keyStoreFile=").append(this.keyStoreFilePath);
        if (this.trustMgrs != null) {
            buf.append(", trustMgrs=").append(Arrays.toString(this.trustMgrs));
        } else {
            buf.append(", trustStoreFile=").append(this.trustStoreFilePath);
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    protected void checkParameters() throws SSLException {
        assert (this.keyStoreType != null);
        assert (this.proto != null);
        this.checkNullParameter(this.keyStoreFilePath, "keyStoreFilePath");
        this.checkNullParameter(this.keyStorePwd, "keyStorePwd");
        if (this.trustMgrs == null) {
            if (this.trustStoreFilePath == null) {
                throw new SSLException("Failed to initialize SSL context (either trustStoreFilePath or trustManagers must be provided)");
            }
            this.checkNullParameter(this.trustStorePwd, "trustStorePwd");
        }
    }

    protected InputStream openFileInputStream(String filePath) throws IOException {
        return new FileInputStream(filePath);
    }

    protected KeyStore loadKeyStore(String keyStoreType, String storeFilePath, char[] keyStorePwd) throws SSLException {
        KeyStore keyStore;
        block10: {
            KeyStore keyStore2 = KeyStore.getInstance(keyStoreType);
            InputStream input = this.openFileInputStream(storeFilePath);
            try {
                keyStore2.load(input, keyStorePwd);
                keyStore = keyStore2;
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (GeneralSecurityException e) {
                    throw new SSLException("Failed to initialize key store (security exception occurred) [type=" + keyStoreType + ", keyStorePath=" + storeFilePath + "]", e);
                }
                catch (FileNotFoundException e) {
                    throw new SSLException("Failed to initialize key store (key store file was not found): [path=" + storeFilePath + ", msg=" + e.getMessage() + "]");
                }
                catch (IOException e) {
                    throw new SSLException("Failed to initialize key store (I/O error occurred): " + storeFilePath, e);
                }
            }
            input.close();
        }
        return keyStore;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.parameters();
    }

    private static class DisabledX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] CERTS = new X509Certificate[0];

        private DisabledX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return CERTS;
        }
    }
}

