/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.collector;

import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.traverser.Traverser;
import org.apache.iotdb.db.metadata.path.PartialPath;

public abstract class CollectorTraverser<T>
extends Traverser {
    protected int limit;
    protected int offset;
    protected boolean hasLimit = false;
    protected int count = 0;
    protected int curOffset = -1;
    protected T resultSet;

    public CollectorTraverser(IMNode startNode, PartialPath path) throws MetadataException {
        super(startNode, path);
    }

    public CollectorTraverser(IMNode startNode, PartialPath path, int limit, int offset) throws MetadataException {
        super(startNode, path);
        this.limit = limit;
        this.offset = offset;
        if (limit > 0 || offset > 0) {
            this.hasLimit = true;
        }
    }

    @Override
    protected void traverse(IMNode node, int idx, int level) throws MetadataException {
        if (this.hasLimit && this.count == this.limit) {
            return;
        }
        super.traverse(node, idx, level);
    }

    public T getResult() {
        return this.resultSet;
    }

    public void setResultSet(T resultSet) {
        this.resultSet = resultSet;
    }

    public int getCurOffset() {
        return this.curOffset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        if (limit > 0) {
            this.hasLimit = true;
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
        if (offset > 0) {
            this.hasLimit = true;
        }
    }
}

